/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.JukeboxUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RandHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WeightedElement;

public class EntityBackpackAdditionHandler {
    private static final int MAX_DIFFICULTY = 3;
    private static final String SPAWNED_WITH_BACKPACK = "spawnedWithBackpack";
    private static final String SPAWNED_WITH_JUKEBOX_UPGRADE = "sophisticatedbackpacks:jukebox";
    private static final List<WeightedElement<Item>> HELMET_CHANCES = ImmutableList.of(new WeightedElement<Item>(1, Items.field_234763_ls_), new WeightedElement<Item>(3, Items.field_151161_ac), new WeightedElement<Item>(9, Items.field_151169_ag), new WeightedElement<Item>(27, Items.field_151028_Y), new WeightedElement<Item>(81, Items.field_151024_Q), new WeightedElement<Item>(243, Items.field_190931_a));
    private static final List<WeightedElement<Item>> LEGGINGS_CHANCES = ImmutableList.of(new WeightedElement<Item>(1, Items.field_234765_lu_), new WeightedElement<Item>(3, Items.field_151173_ae), new WeightedElement<Item>(9, Items.field_151149_ai), new WeightedElement<Item>(27, Items.field_151165_aa), new WeightedElement<Item>(81, Items.field_151026_S), new WeightedElement<Item>(243, Items.field_190931_a));
    private static final List<WeightedElement<Item>> BOOTS_CHANCES = ImmutableList.of(new WeightedElement<Item>(1, Items.field_234766_lv_), new WeightedElement<Item>(3, Items.field_151175_af), new WeightedElement<Item>(9, Items.field_151151_aj), new WeightedElement<Item>(27, Items.field_151167_ab), new WeightedElement<Item>(81, Items.field_151021_T), new WeightedElement<Item>(243, Items.field_190931_a));
    private static final List<WeightedElement<BackpackAddition>> BACKPACK_CHANCES = ImmutableList.of(new WeightedElement<BackpackAddition>(1, new BackpackAddition((Item)ModItems.NETHERITE_BACKPACK.get(), 4, HELMET_CHANCES.subList(0, 2), LEGGINGS_CHANCES.subList(0, 2), BOOTS_CHANCES.subList(0, 3))), new WeightedElement<BackpackAddition>(5, new BackpackAddition((Item)ModItems.DIAMOND_BACKPACK.get(), 3, HELMET_CHANCES.subList(0, 3), LEGGINGS_CHANCES.subList(0, 3), BOOTS_CHANCES.subList(0, 3))), new WeightedElement<BackpackAddition>(25, new BackpackAddition((Item)ModItems.GOLD_BACKPACK.get(), 2, HELMET_CHANCES.subList(1, 4), LEGGINGS_CHANCES.subList(1, 4), BOOTS_CHANCES.subList(1, 4))), new WeightedElement<BackpackAddition>(125, new BackpackAddition((Item)ModItems.IRON_BACKPACK.get(), 1, HELMET_CHANCES.subList(2, 5), LEGGINGS_CHANCES.subList(2, 5), BOOTS_CHANCES.subList(2, 5))), new WeightedElement<BackpackAddition>(625, new BackpackAddition((Item)ModItems.BACKPACK.get(), 0, HELMET_CHANCES.subList(3, 6), LEGGINGS_CHANCES.subList(3, 6), BOOTS_CHANCES.subList(3, 6))));
    private static List<MusicDiscItem> musicDiscs = null;
    private static final List<ApplicableEffect> APPLICABLE_EFFECTS = ImmutableList.of((Object)new ApplicableEffect(Effects.field_76429_m, 3), (Object)new ApplicableEffect(Effects.field_76426_n), (Object)new ApplicableEffect(Effects.field_76444_x), (Object)new ApplicableEffect(Effects.field_180152_w), (Object)new ApplicableEffect(Effects.field_76428_l), (Object)new ApplicableEffect(Effects.field_76424_c), (Object)new ApplicableEffect(Effects.field_76420_g));

    private EntityBackpackAdditionHandler() {
    }

    static void addBackpack(MonsterEntity monster) {
        Random rnd = monster.field_70170_p.field_73012_v;
        if (!Config.COMMON.entityBackpackAdditions.canWearBackpack(monster.func_200600_R()) || rnd.nextInt((int)(1.0 / (Double)Config.COMMON.entityBackpackAdditions.chance.get())) != 0) {
            return;
        }
        RandHelper.getRandomWeightedElement(rnd, BACKPACK_CHANCES).ifPresent(backpackAddition -> {
            ItemStack backpack = new ItemStack((IItemProvider)backpackAddition.getBackpackItem());
            int minDifficulty = backpackAddition.getMinDifficulty();
            int difficulty = Math.max(minDifficulty, rnd.nextInt(4));
            EntityBackpackAdditionHandler.equipBackpack(monster, backpack, difficulty, Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.playJukebox.get()) && rnd.nextInt(4) == 0);
            EntityBackpackAdditionHandler.applyPotions(monster, difficulty, minDifficulty);
            EntityBackpackAdditionHandler.raiseHealth(monster, minDifficulty);
            if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.equipWithArmor.get())) {
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getHelmetChances(), EquipmentSlotType.HEAD);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getLeggingsChances(), EquipmentSlotType.LEGS);
                EntityBackpackAdditionHandler.equipArmorPiece(monster, rnd, minDifficulty, backpackAddition.getBootsChances(), EquipmentSlotType.FEET);
            }
            monster.func_184211_a(SPAWNED_WITH_BACKPACK);
        });
    }

    private static void equipArmorPiece(MonsterEntity monster, Random rnd, int minDifficulty, List<WeightedElement<Item>> armorChances, EquipmentSlotType slot) {
        RandHelper.getRandomWeightedElement(rnd, armorChances).ifPresent(armorPiece -> {
            if (armorPiece != Items.field_190931_a) {
                ItemStack armorStack = new ItemStack((IItemProvider)armorPiece);
                if (rnd.nextInt(6 - minDifficulty) == 0) {
                    float additionalDifficulty = monster.field_70170_p.func_175649_E(monster.func_233580_cy_()).func_180170_c();
                    int level = (int)(5.0f + additionalDifficulty * 18.0f + (float)(minDifficulty * 6));
                    EnchantmentHelper.func_77504_a((Random)rnd, (ItemStack)armorStack, (int)level, (boolean)true);
                }
                monster.func_184201_a(slot, armorStack);
            }
        });
    }

    private static void equipBackpack(MonsterEntity monster, ItemStack backpack, int difficulty, boolean playMusicDisc) {
        EntityBackpackAdditionHandler.getSpawnEgg(monster.func_200600_R()).ifPresent(egg -> backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(w -> {
            w.setColors(EntityBackpackAdditionHandler.getPrimaryColor(egg), EntityBackpackAdditionHandler.getSecondaryColor(egg));
            EntityBackpackAdditionHandler.setLoot(monster, w, difficulty);
            if (playMusicDisc) {
                w.getInventoryHandler();
                if (w.getUpgradeHandler().getSlots() > 0) {
                    monster.func_184211_a(SPAWNED_WITH_JUKEBOX_UPGRADE);
                    EntityBackpackAdditionHandler.addJukeboxUpgradeAndRandomDisc(monster, w);
                }
            }
        }));
        monster.func_184201_a(EquipmentSlotType.CHEST, backpack);
    }

    private static void addJukeboxUpgradeAndRandomDisc(MonsterEntity monster, IBackpackWrapper w) {
        w.getUpgradeHandler().setStackInSlot(0, new ItemStack((IItemProvider)ModItems.JUKEBOX_UPGRADE.get()));
        Iterator<JukeboxUpgradeItem.Wrapper> it = w.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).iterator();
        if (it.hasNext()) {
            JukeboxUpgradeItem.Wrapper wrapper = it.next();
            List<MusicDiscItem> musicDiscs = EntityBackpackAdditionHandler.getMusicDiscs();
            wrapper.setDisc(new ItemStack((IItemProvider)musicDiscs.get(monster.field_70170_p.field_73012_v.nextInt(musicDiscs.size()))));
        }
    }

    private static List<MusicDiscItem> getMusicDiscs() {
        if (musicDiscs == null) {
            Map records = (Map)ObfuscationReflectionHelper.getPrivateValue(MusicDiscItem.class, null, (String)"field_150928_b");
            if (records == null) {
                musicDiscs = new ArrayList<MusicDiscItem>();
            } else {
                HashSet blockedDiscs = new HashSet((Collection)Config.COMMON.entityBackpackAdditions.discBlockList.get());
                musicDiscs = new ArrayList<MusicDiscItem>();
                records.forEach((sound, musicDisc) -> {
                    if (!blockedDiscs.contains(musicDisc.getRegistryName().toString())) {
                        musicDiscs.add((MusicDiscItem)musicDisc);
                    }
                });
            }
        }
        return musicDiscs;
    }

    private static void raiseHealth(MonsterEntity monster, int minDifficulty) {
        if (Boolean.FALSE.equals(Config.COMMON.entityBackpackAdditions.buffHealth.get())) {
            return;
        }
        ModifiableAttributeInstance maxHealth = monster.func_110148_a(Attributes.field_233818_a_);
        if (maxHealth != null) {
            double healthAddition = maxHealth.func_111125_b() * (double)minDifficulty;
            if (healthAddition > 0.1) {
                maxHealth.func_233769_c_(new AttributeModifier("Backpack bearer health bonus", healthAddition, AttributeModifier.Operation.ADDITION));
            }
            monster.func_70606_j(monster.func_110138_aP());
        }
    }

    private static Optional<SpawnEggItem> getSpawnEgg(EntityType<?> entityType) {
        Map eggs = (Map)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, null, (String)"field_195987_b");
        return eggs == null ? Optional.empty() : Optional.ofNullable((SpawnEggItem)eggs.get(entityType));
    }

    private static int getPrimaryColor(SpawnEggItem egg) {
        Integer primaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"field_195988_c");
        return primaryColor == null ? -1 : primaryColor;
    }

    private static int getSecondaryColor(SpawnEggItem egg) {
        Integer secondaryColor = (Integer)ObfuscationReflectionHelper.getPrivateValue(SpawnEggItem.class, (Object)egg, (String)"field_195989_d");
        return secondaryColor == null ? -1 : secondaryColor;
    }

    private static void setLoot(MonsterEntity monster, IBackpackWrapper backpackWrapper, int difficulty) {
        MinecraftServer server = monster.field_70170_p.func_73046_m();
        if (server == null) {
            return;
        }
        if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.addLoot.get())) {
            EntityBackpackAdditionHandler.addLoot(monster, backpackWrapper, difficulty);
        }
    }

    private static void applyPotions(MonsterEntity monster, int difficulty, int minDifficulty) {
        if (Boolean.TRUE.equals(Config.COMMON.entityBackpackAdditions.buffWithPotionEffects.get())) {
            RandHelper.getNRandomElements(APPLICABLE_EFFECTS, difficulty + 2).forEach(applicableEffect -> {
                int amplifier = Math.min(Math.max(minDifficulty, monster.field_70170_p.field_73012_v.nextInt(difficulty + 1)), applicableEffect.getMaxAmplifier());
                monster.func_195064_c(new EffectInstance(applicableEffect.getEffect(), 36000, amplifier));
            });
        }
    }

    private static void addLoot(MonsterEntity monster, IBackpackWrapper backpackWrapper, int difficulty) {
        if (difficulty != 0) {
            Config.COMMON.entityBackpackAdditions.getLootTableName(monster.func_200600_R()).ifPresent(lootTableName -> {
                float lootPercentage = (float)difficulty / 3.0f;
                backpackWrapper.setLoot((ResourceLocation)lootTableName, lootPercentage);
            });
        }
    }

    static void handleBackpackDrop(LivingDropsEvent event) {
        if (event.getEntity().func_184216_O().contains(SPAWNED_WITH_BACKPACK) && (!(event.getSource().func_76346_g() instanceof PlayerEntity) || event.getSource().func_76346_g() instanceof FakePlayer)) {
            event.getDrops().removeIf(drop -> drop.func_92059_d().func_77973_b() instanceof BackpackItem);
        }
    }

    public static void removeBeneficialEffects(CreeperEntity creeper) {
        if (creeper.func_184216_O().contains(SPAWNED_WITH_BACKPACK)) {
            creeper.func_70651_bq().removeIf(e -> e.func_188419_a().func_188408_i());
        }
    }

    public static void removeBackpackUuid(MonsterEntity entity) {
        if (entity.func_233643_dh_() || !entity.func_184216_O().contains(SPAWNED_WITH_BACKPACK)) {
            return;
        }
        entity.func_184582_a(EquipmentSlotType.CHEST).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getContentsUuid().ifPresent(uuid -> BackpackStorage.get().removeBackpackContents((UUID)uuid)));
    }

    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!entity.func_184216_O().contains(SPAWNED_WITH_JUKEBOX_UPGRADE)) {
            return;
        }
        entity.func_184582_a(EquipmentSlotType.CHEST).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getUpgradeHandler().getTypeWrappers(JukeboxUpgradeItem.TYPE).forEach(wrapper -> {
            if (wrapper.isPlaying()) {
                wrapper.tick(entity, entity.field_70170_p, entity.func_233580_cy_());
            } else {
                wrapper.play(entity);
            }
        }));
    }

    private static class ApplicableEffect {
        private final Effect effect;
        private final int maxAmplifier;

        private ApplicableEffect(Effect effect) {
            this(effect, Integer.MAX_VALUE);
        }

        private ApplicableEffect(Effect effect, int maxAmplifier) {
            this.effect = effect;
            this.maxAmplifier = maxAmplifier;
        }

        public Effect getEffect() {
            return this.effect;
        }

        public int getMaxAmplifier() {
            return this.maxAmplifier;
        }
    }

    private static class BackpackAddition {
        private final Item backpackItem;
        private final int minDifficulty;
        private final List<WeightedElement<Item>> helmetChances;
        private final List<WeightedElement<Item>> leggingsChances;
        private final List<WeightedElement<Item>> bootsChances;

        public List<WeightedElement<Item>> getHelmetChances() {
            return this.helmetChances;
        }

        public List<WeightedElement<Item>> getLeggingsChances() {
            return this.leggingsChances;
        }

        public List<WeightedElement<Item>> getBootsChances() {
            return this.bootsChances;
        }

        private BackpackAddition(Item backpackItem, int minDifficulty, List<WeightedElement<Item>> helmetChances, List<WeightedElement<Item>> leggingsChances, List<WeightedElement<Item>> bootsChances) {
            this.backpackItem = backpackItem;
            this.minDifficulty = minDifficulty;
            this.helmetChances = helmetChances;
            this.leggingsChances = leggingsChances;
            this.bootsChances = bootsChances;
        }

        public Item getBackpackItem() {
            return this.backpackItem;
        }

        public int getMinDifficulty() {
            return this.minDifficulty;
        }
    }
}

