/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTileEntity;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.NoopBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import net.p3pp3rf1y.sophisticatedbackpacks.util.WorldHelper;

public abstract class BackpackContext {
    private final ContainerType<BackpackContainer> containerType;

    protected BackpackContext(ContainerType<BackpackContainer> containerType) {
        this.containerType = containerType;
    }

    public abstract Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity var1);

    public abstract boolean shouldLockBackpackSlot();

    public abstract IBackpackWrapper getBackpackWrapper(PlayerEntity var1);

    public ContainerType<BackpackContainer> getContainerType() {
        return this.containerType;
    }

    public abstract int getBackpackSlotIndex();

    public abstract BackpackContext getSubBackpackContext(int var1);

    public abstract BackpackContext getParentBackpackContext();

    public abstract void toBuffer(PacketBuffer var1);

    public abstract boolean canInteractWith(PlayerEntity var1);

    public BlockPos getBackpackPosition(PlayerEntity playerEntity) {
        return playerEntity.func_233580_cy_();
    }

    public static class BlockSubBackpack
    extends Block {
        private final int subBackpackSlotIndex;
        @Nullable
        private IBackpackWrapper parentWrapper;

        public BlockSubBackpack(BlockPos pos, int subBackpackSlotIndex) {
            super((ContainerType<BackpackContainer>)((ContainerType)ModItems.BLOCK_SUBBACKPACK_CONTAINER_TYPE.get()), pos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE)).orElse(NoopBackpackWrapper.INSTANCE);
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new BlockSubBackpack(BlockPos.func_218283_e((long)packetBuffer.readLong()), packetBuffer.readInt());
        }

        @Override
        public void toBuffer(PacketBuffer packetBuffer) {
            super.toBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Block(this.pos);
        }
    }

    public static class Block
    extends BackpackContext {
        protected final BlockPos pos;

        public Block(BlockPos pos) {
            this((ContainerType<BackpackContainer>)((ContainerType)ModItems.BACKPACK_BLOCK_CONTAINER_TYPE.get()), pos);
        }

        public Block(ContainerType<BackpackContainer> containerType, BlockPos pos) {
            super(containerType);
            this.pos = pos;
        }

        @Override
        public BlockPos getBackpackPosition(PlayerEntity playerEntity) {
            return this.pos;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot() {
            return false;
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return WorldHelper.getTile((IBlockReader)player.field_70170_p, this.pos, BackpackTileEntity.class).map(BackpackTileEntity::getBackpackWrapper).orElse(NoopBackpackWrapper.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return -1;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new BlockSubBackpack(this.pos, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new Block(BlockPos.func_218283_e((long)packetBuffer.readLong()));
        }

        @Override
        public void toBuffer(PacketBuffer packetBuffer) {
            packetBuffer.writeLong(this.pos.func_218275_a());
        }

        @Override
        public boolean canInteractWith(PlayerEntity player) {
            return player.field_70170_p.func_175625_s(this.pos) instanceof BackpackTileEntity && player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
        }
    }

    public static class ItemSubBackpack
    extends Item {
        private final int subBackpackSlotIndex;
        @Nullable
        private IBackpackWrapper parentWrapper;

        public ItemSubBackpack(String handlerName, int backpackSlotIndex, int subBackpackSlotIndex) {
            super((ContainerType<BackpackContainer>)((ContainerType)ModItems.ITEM_SUBBACKPACK_CONTAINER_TYPE.get()), handlerName, backpackSlotIndex);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return this.getParentBackpackWrapper(player).map(parent -> (IBackpackWrapper)parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE)).orElse(NoopBackpackWrapper.INSTANCE);
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new ItemSubBackpack(packetBuffer.func_218666_n(), packetBuffer.readInt(), packetBuffer.readInt());
        }

        @Override
        public void toBuffer(PacketBuffer packetBuffer) {
            super.toBuffer(packetBuffer);
            packetBuffer.writeInt(this.subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return new Item(this.handlerName, this.backpackSlotIndex);
        }
    }

    public static class Item
    extends BackpackContext {
        protected final String handlerName;
        protected final int backpackSlotIndex;

        public Item(String handlerName, int backpackSlotIndex) {
            this((ContainerType<BackpackContainer>)((ContainerType)ModItems.BACKPACK_ITEM_CONTAINER_TYPE.get()), handlerName, backpackSlotIndex);
        }

        public Item(ContainerType<BackpackContainer> containerType, String handlerName, int backpackSlotIndex) {
            super(containerType);
            this.handlerName = handlerName;
            this.backpackSlotIndex = backpackSlotIndex;
        }

        @Override
        public Optional<IBackpackWrapper> getParentBackpackWrapper(PlayerEntity player) {
            return Optional.empty();
        }

        @Override
        public boolean shouldLockBackpackSlot() {
            return PlayerInventoryProvider.getPlayerInventoryHandler(this.handlerName).map(PlayerInventoryHandler::isVisibleInGui).orElse(false);
        }

        @Override
        public IBackpackWrapper getBackpackWrapper(PlayerEntity player) {
            return PlayerInventoryProvider.getPlayerInventoryHandler(this.handlerName).map(h -> (IBackpackWrapper)h.getStackInSlot(player, this.backpackSlotIndex).getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).orElse((Object)NoopBackpackWrapper.INSTANCE)).orElse(NoopBackpackWrapper.INSTANCE);
        }

        @Override
        public int getBackpackSlotIndex() {
            return this.backpackSlotIndex;
        }

        @Override
        public BackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
            return new ItemSubBackpack(this.handlerName, this.backpackSlotIndex, subBackpackSlotIndex);
        }

        @Override
        public BackpackContext getParentBackpackContext() {
            return this;
        }

        public static BackpackContext fromBuffer(PacketBuffer packetBuffer) {
            return new Item(packetBuffer.func_218666_n(), packetBuffer.readInt());
        }

        @Override
        public void toBuffer(PacketBuffer packetBuffer) {
            packetBuffer.func_180714_a(this.handlerName);
            packetBuffer.writeInt(this.backpackSlotIndex);
        }

        @Override
        public boolean canInteractWith(PlayerEntity player) {
            return true;
        }
    }
}

