/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.common.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.UpgradeContainerType;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.ServerBackpackDataMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public abstract class UpgradeContainerBase<W extends IUpgradeWrapper, C extends UpgradeContainerBase<W, C>>
implements IServerUpdater {
    protected final ArrayList<Slot> slots = new ArrayList();
    private final int upgradeContainerId;
    protected W upgradeWrapper;
    protected final PlayerEntity player;
    private final UpgradeContainerType<W, C> type;
    private boolean isOpen = false;

    protected UpgradeContainerBase(PlayerEntity player, int upgradeContainerId, W upgradeWrapper, UpgradeContainerType<W, C> type) {
        this.upgradeContainerId = upgradeContainerId;
        this.upgradeWrapper = upgradeWrapper;
        this.player = player;
        this.type = type;
    }

    public List<Slot> getSlots() {
        return this.slots;
    }

    public UpgradeContainerType<W, C> getType() {
        return this.type;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void sendBooleanToServer(String key, boolean value) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        this.sendDataToServer(() -> NBTHelper.putBoolean(new CompoundNBT(), key, value));
    }

    @Override
    public void sendDataToServer(Supplier<CompoundNBT> supplyData) {
        if (!this.player.field_70170_p.field_72995_K) {
            return;
        }
        CompoundNBT data = supplyData.get();
        data.func_74768_a("containerId", this.upgradeContainerId);
        PacketHandler.sendToServer(new ServerBackpackDataMessage(data));
    }

    public void onInit() {
    }

    public abstract void handleMessage(CompoundNBT var1);

    public ItemStack getUpgradeStack() {
        return this.upgradeWrapper.getUpgradeStack();
    }

    public W getUpgradeWrapper() {
        return this.upgradeWrapper;
    }

    public void setUpgradeWrapper(IUpgradeWrapper updatedUpgradeWrapper) {
        this.upgradeWrapper = updatedUpgradeWrapper;
    }

    public boolean containsSlot(Slot slot) {
        for (Slot containerSlot : this.slots) {
            if (containerSlot != slot) continue;
            return true;
        }
        return false;
    }

    public ItemStack getSlotStackToTransfer(Slot slot) {
        return slot.func_75211_c();
    }

    public void onTakeFromSlot(Slot slot, PlayerEntity player, ItemStack slotStack) {
        slot.func_190901_a(player, slotStack);
    }

    public boolean mergeIntoBackpackFirst(Slot slot) {
        return true;
    }

    public boolean allowsPickupAll(Slot slot) {
        return true;
    }

    public int getUpgradeContainerId() {
        return this.upgradeContainerId;
    }
}

