/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.craftingtweaks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.DefaultProviderV2;
import net.blay09.mods.craftingtweaks.api.RotationHandler;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.ICraftingContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class CraftingUpgradeTweakProvider
implements TweakProvider<BackpackContainer> {
    private static final RotationHandler ROTATION_HANDLER = new RotationHandler(){

        public boolean ignoreSlotId(int slotId) {
            return slotId == 4;
        }

        public int rotateSlotId(int slotId, boolean counterClockwise) {
            if (!counterClockwise) {
                switch (slotId) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 0;
                    }
                    case 5: {
                        return 8;
                    }
                    case 6: {
                        return 3;
                    }
                    case 7: {
                        return 6;
                    }
                    case 8: {
                        return 7;
                    }
                }
            } else {
                switch (slotId) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 6;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 8;
                    }
                    case 8: {
                        return 5;
                    }
                }
            }
            return 0;
        }
    };
    private final DefaultProviderV2 defaultProvider = CraftingTweaksAPI.createDefaultProviderV2();

    public String getModId() {
        return "sophisticatedbackpacks";
    }

    public boolean load() {
        return true;
    }

    public void clearGrid(PlayerEntity entityPlayer, BackpackContainer container, int id, boolean forced) {
        IInventory craftMatrix = this.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix != null) {
            int start = this.getCraftingGridStart(entityPlayer, container, id);
            int size = this.getCraftingGridSize(entityPlayer, container, id);
            for (int slotNumber = start; slotNumber < start + size; ++slotNumber) {
                Slot slot = container.func_75139_a(slotNumber);
                int slotIndex = slot.getSlotIndex();
                container.func_82846_b(entityPlayer, slotNumber);
                if (!slot.func_75216_d() || !forced) continue;
                entityPlayer.func_71019_a(slot.func_75211_c(), false);
                craftMatrix.func_70299_a(slotIndex, ItemStack.field_190927_a);
            }
            container.func_75142_b();
        }
    }

    public void rotateGrid(PlayerEntity entityPlayer, BackpackContainer container, int id, boolean counterClockwise) {
        IInventory craftMatrix = this.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix != null) {
            int slotIndex;
            int i;
            int start = this.getCraftingGridStart(entityPlayer, container, id);
            int size = this.getCraftingGridSize(entityPlayer, container, id);
            Inventory matrixClone = new Inventory(size);
            for (i = 0; i < size; ++i) {
                slotIndex = container.func_75139_a(start + i).getSlotIndex();
                matrixClone.func_70299_a(i, craftMatrix.func_70301_a(slotIndex));
            }
            for (i = 0; i < size; ++i) {
                if (ROTATION_HANDLER.ignoreSlotId(i)) continue;
                slotIndex = container.func_75139_a(start + ROTATION_HANDLER.rotateSlotId(i, counterClockwise)).getSlotIndex();
                craftMatrix.func_70299_a(slotIndex, matrixClone.func_70301_a(i));
            }
            container.func_75142_b();
        }
    }

    public void balanceGrid(PlayerEntity entityPlayer, BackpackContainer container, int id) {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = this.getCraftingGridStart(entityPlayer, container, id);
        int size = this.getCraftingGridSize(entityPlayer, container, id);
        for (int i = start; i < start + size; ++i) {
            ItemStack itemStack = container.func_75139_a(i).func_75211_c();
            if (itemStack.func_190926_b() || itemStack.func_77976_d() <= 1) continue;
            ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
            String key = Objects.toString(registryName);
            itemMap.put((Object)key, (Object)itemStack);
            itemCount.add((Object)key, itemStack.func_190916_E());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.func_190920_e(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.func_190916_E() < itemStack.func_77976_d()) {
                    itemStack.func_190917_f(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        container.func_75142_b();
    }

    public void spreadGrid(PlayerEntity entityPlayer, BackpackContainer container, int id) {
        boolean emptyBiggestSlot;
        do {
            ItemStack biggestSlotStack = null;
            int biggestSlotSize = 1;
            int start = this.getCraftingGridStart(entityPlayer, container, id);
            int size = this.getCraftingGridSize(entityPlayer, container, id);
            for (int i = start; i < start + size; ++i) {
                ItemStack itemStack = container.func_75139_a(i).func_75211_c();
                if (itemStack.func_190926_b() || itemStack.func_190916_E() <= biggestSlotSize) continue;
                biggestSlotStack = itemStack;
                biggestSlotSize = itemStack.func_190916_E();
            }
            if (biggestSlotStack == null) {
                return;
            }
            emptyBiggestSlot = false;
            for (int i = start; i < start + size; ++i) {
                Slot slot = container.func_75139_a(i);
                ItemStack itemStack = slot.func_75211_c();
                if (!itemStack.func_190926_b()) continue;
                if (biggestSlotStack.func_190916_E() > 1) {
                    slot.func_75215_d(biggestSlotStack.func_77979_a(1));
                    continue;
                }
                emptyBiggestSlot = true;
            }
        } while (emptyBiggestSlot);
        this.balanceGrid(this, id, entityPlayer, container);
    }

    private <T extends Container> void balanceGrid(TweakProvider<T> provider, int id, PlayerEntity entityPlayer, T container) {
        ArrayListMultimap itemMap = ArrayListMultimap.create();
        HashMultiset itemCount = HashMultiset.create();
        int start = provider.getCraftingGridStart(entityPlayer, container, id);
        int size = provider.getCraftingGridSize(entityPlayer, container, id);
        for (int slotNumber = start; slotNumber < start + size; ++slotNumber) {
            ItemStack itemStack = container.func_75139_a(slotNumber).func_75211_c();
            if (itemStack.func_190926_b() || itemStack.func_77976_d() <= 1) continue;
            ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
            String key = Objects.toString(registryName);
            itemMap.put((Object)key, (Object)itemStack);
            itemCount.add((Object)key, itemStack.func_190916_E());
        }
        for (String key : itemMap.keySet()) {
            List balanceList = itemMap.get((Object)key);
            int totalCount = itemCount.count((Object)key);
            int countPerStack = totalCount / balanceList.size();
            int restCount = totalCount % balanceList.size();
            for (ItemStack itemStack : balanceList) {
                itemStack.func_190920_e(countPerStack);
            }
            int idx = 0;
            while (restCount > 0) {
                ItemStack itemStack;
                itemStack = (ItemStack)balanceList.get(idx);
                if (itemStack.func_190916_E() < itemStack.func_77976_d()) {
                    itemStack.func_190917_f(1);
                    --restCount;
                }
                if (++idx < balanceList.size()) continue;
                idx = 0;
            }
        }
        container.func_75142_b();
    }

    public boolean canTransferFrom(PlayerEntity entityPlayer, BackpackContainer container, int id, Slot sourceSlot) {
        return sourceSlot.func_82869_a(entityPlayer) && sourceSlot.field_75222_d < container.field_75151_b.size();
    }

    public boolean transferIntoGrid(PlayerEntity entityPlayer, BackpackContainer container, int id, Slot sourceSlot) {
        IInventory craftMatrix = this.getCraftMatrix(entityPlayer, container, id);
        if (craftMatrix == null) {
            return false;
        }
        int start = this.getCraftingGridStart(entityPlayer, container, id);
        int size = this.getCraftingGridSize(entityPlayer, container, id);
        ItemStack itemStack = sourceSlot.func_75211_c();
        if (itemStack.func_190926_b()) {
            return false;
        }
        int firstEmptySlot = -1;
        for (int i = start; i < start + size; ++i) {
            int slotIndex = container.func_75139_a(i).getSlotIndex();
            ItemStack craftStack = craftMatrix.func_70301_a(slotIndex);
            if (!craftStack.func_190926_b()) {
                int spaceLeft;
                if (!craftStack.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)craftStack, (ItemStack)itemStack) || (spaceLeft = Math.min(craftMatrix.func_70297_j_(), craftStack.func_77976_d()) - craftStack.func_190916_E()) <= 0) continue;
                ItemStack splitStack = itemStack.func_77979_a(Math.min(spaceLeft, itemStack.func_190916_E()));
                craftStack.func_190917_f(splitStack.func_190916_E());
                if (itemStack.func_190916_E() > 0) continue;
                return true;
            }
            if (firstEmptySlot != -1) continue;
            firstEmptySlot = slotIndex;
        }
        if (itemStack.func_190916_E() > 0 && firstEmptySlot != -1) {
            ItemStack transferStack = itemStack.func_77979_a(Math.min(itemStack.func_190916_E(), craftMatrix.func_70297_j_()));
            craftMatrix.func_70299_a(firstEmptySlot, transferStack);
            return true;
        }
        return false;
    }

    public ItemStack putIntoGrid(PlayerEntity entityPlayer, BackpackContainer container, int id, ItemStack itemStack, int index) {
        return this.defaultProvider.putIntoGrid((TweakProvider)this, id, entityPlayer, (Container)container, itemStack, index);
    }

    public IInventory getCraftMatrix(PlayerEntity entityPlayer, BackpackContainer container, int id) {
        return this.getOpenCraftingContainer(container).map(ICraftingContainer::getCraftMatrix).orElse(InventoryHelper.NOOP_INVENTORY);
    }

    public boolean requiresServerSide() {
        return true;
    }

    private Optional<ICraftingContainer> getOpenCraftingContainer(BackpackContainer container) {
        return container.getOpenContainer().flatMap(c -> c instanceof ICraftingContainer ? Optional.of((ICraftingContainer)((Object)c)) : Optional.empty());
    }

    public int getCraftingGridStart(PlayerEntity entityPlayer, BackpackContainer container, int id) {
        return this.getOpenCraftingContainer(container).map(cc -> {
            List<Slot> recipeSlots = cc.getRecipeSlots();
            if (!recipeSlots.isEmpty()) {
                return recipeSlots.get((int)0).field_75222_d;
            }
            return 0;
        }).orElse(0);
    }

    public int getCraftingGridSize(PlayerEntity entityPlayer, BackpackContainer container, int id) {
        return 9;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initGui(ContainerScreen<BackpackContainer> guiContainer, GuiScreenEvent.InitGuiEvent event) {
    }

    public boolean isValidContainer(Container container) {
        return container instanceof BackpackContainer;
    }
}

