/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.curios;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.ICompat;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.curios.CuriosBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosCompat
implements ICompat {
    public CuriosCompat() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::sendImc);
        MinecraftForge.EVENT_BUS.addGenericListener(ItemStack.class, this::onAttachCapabilities);
        PlayerInventoryProvider.addPlayerInventoryHandler("curios", player -> CuriosCompat.getFromBackStackHandler((LivingEntity)player, ICurioStacksHandler::getSlots, 0), (player, slot) -> CuriosCompat.getFromBackStackHandler((LivingEntity)player, sh -> sh.getStacks().getStackInSlot(slot.intValue()), ItemStack.field_190927_a), (player, slot, stack) -> this.runOnBackStackHandler(player, sh -> sh.getStacks().setStackInSlot(slot, stack)), false, true, true);
    }

    public static <T> T getFromBackStackHandler(LivingEntity livingEntity, Function<ICurioStacksHandler, T> getFromHandler, T defaultValue) {
        return CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).map(h -> h.getStacksHandler(SlotTypePreset.BACK.getIdentifier()).map(getFromHandler).orElse(defaultValue)).orElse(defaultValue);
    }

    private void runOnBackStackHandler(PlayerEntity player, Consumer<ICurioStacksHandler> runOnHandler) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(h -> h.getStacksHandler(SlotTypePreset.BACK.getIdentifier()).ifPresent(runOnHandler));
    }

    private void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BACK.getMessageBuilder().build());
    }

    public void onAttachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ItemStack stack = (ItemStack)evt.getObject();
        Item item = stack.func_77973_b();
        if (item.getRegistryName() != null && item.getRegistryName().func_110624_b().equals("sophisticatedbackpacks") && item instanceof BackpackItem) {
            evt.addCapability(new ResourceLocation("sophisticatedbackpacks", item.getRegistryName().func_110623_a() + "_curios"), new ICapabilityProvider(){

                public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
                    return CuriosCapability.ITEM.orEmpty(cap, LazyOptional.of(CuriosBackpackWrapper::new));
                }
            });
        }
    }

    @Override
    public void setup() {
    }
}

