/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.compat.jei;

import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.BackpackScreen;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.FilterSlotItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.jei.CraftingContainerRecipeTransferHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.jei.DyeRecipesMaker;
import net.p3pp3rf1y.sophisticatedbackpacks.compat.jei.SetGhostSlotMessage;
import net.p3pp3rf1y.sophisticatedbackpacks.init.ModItems;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;

@JeiPlugin
public class SBPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("sophisticatedbackpacks", "default");
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        ISubtypeInterpreter backpackNbtInterpreter = itemStack -> itemStack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).map(wrapper -> "{clothColor:" + wrapper.getClothColor() + ",borderColor:" + wrapper.getBorderColor() + "}").orElse("");
        registration.registerSubtypeInterpreter((Item)ModItems.BACKPACK.get(), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter((Item)ModItems.IRON_BACKPACK.get(), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter((Item)ModItems.GOLD_BACKPACK.get(), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter((Item)ModItems.DIAMOND_BACKPACK.get(), backpackNbtInterpreter);
        registration.registerSubtypeInterpreter((Item)ModItems.NETHERITE_BACKPACK.get(), backpackNbtInterpreter);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGuiContainerHandler(BackpackScreen.class, (IGuiContainerHandler)new IGuiContainerHandler<BackpackScreen>(){

            public List<Rectangle2d> getGuiExtraAreas(BackpackScreen gui) {
                ArrayList<Rectangle2d> ret = new ArrayList<Rectangle2d>();
                gui.getUpgradeSlotsRectangle().ifPresent(ret::add);
                ret.addAll(gui.getUpgradeSettingsControl().getTabRectangles());
                gui.getSortButtonsRectangle().ifPresent(ret::add);
                return ret;
            }
        });
        registration.addGhostIngredientHandler(BackpackScreen.class, (IGhostIngredientHandler)new IGhostIngredientHandler<BackpackScreen>(){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargets(final BackpackScreen screen, I i, boolean b) {
                ArrayList targets = new ArrayList();
                if (!(i instanceof ItemStack)) {
                    return targets;
                }
                ItemStack ghostStack = (ItemStack)i;
                BackpackContainer container = (BackpackContainer)screen.func_212873_a_();
                container.getOpenContainer().ifPresent(c -> c.getSlots().forEach(s -> {
                    if (s instanceof FilterSlotItemHandler && s.func_75214_a(ghostStack)) {
                        targets.add(new IGhostIngredientHandler.Target<I>((Slot)s, ghostStack){
                            final /* synthetic */ Slot val$s;
                            final /* synthetic */ ItemStack val$ghostStack;
                            {
                                this.val$s = slot;
                                this.val$ghostStack = itemStack;
                            }

                            public Rectangle2d getArea() {
                                return new Rectangle2d(screen.getGuiLeft() + this.val$s.field_75223_e, screen.getGuiTop() + this.val$s.field_75221_f, 17, 17);
                            }

                            public void accept(I i) {
                                PacketHandler.sendToServer(new SetGhostSlotMessage(this.val$ghostStack, this.val$s.field_75222_d));
                            }
                        });
                    }
                }));
                return targets;
            }

            public void onComplete() {
            }
        });
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(DyeRecipesMaker.getRecipes(), VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ModItems.CRAFTING_UPGRADE.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        IRecipeTransferHandlerHelper handlerHelper = registration.getTransferHelper();
        IStackHelper stackHelper = registration.getJeiHelpers().getStackHelper();
        registration.addRecipeTransferHandler((IRecipeTransferHandler)new CraftingContainerRecipeTransferHandler(handlerHelper, stackHelper), VanillaRecipeCategoryUid.CRAFTING);
    }
}

