/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpacks.util.PlayerInventoryProvider;

public class BackpackOpenMessage {
    private final int subBackpackSlotIndex;

    public BackpackOpenMessage() {
        this(-1);
    }

    public BackpackOpenMessage(int subBackpackSlotIndex) {
        this.subBackpackSlotIndex = subBackpackSlotIndex;
    }

    public static void encode(BackpackOpenMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeInt(msg.subBackpackSlotIndex);
    }

    public static BackpackOpenMessage decode(PacketBuffer packetBuffer) {
        return new BackpackOpenMessage(packetBuffer.readInt());
    }

    static void onMessage(BackpackOpenMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> BackpackOpenMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, BackpackOpenMessage msg) {
        if (player == null) {
            return;
        }
        if (player.field_71070_bA instanceof BackpackContainer) {
            BackpackContainer backpackContainer = (BackpackContainer)player.field_71070_bA;
            if (msg.subBackpackSlotIndex == -1) {
                BackpackOpenMessage.openParentBackpack(player, backpackContainer);
            } else {
                BackpackOpenMessage.openSubBackpack(player, msg, backpackContainer);
            }
        } else {
            BackpackOpenMessage.findAndOpenFirstBackpack(player);
        }
    }

    private static void findAndOpenFirstBackpack(ServerPlayerEntity player) {
        PlayerInventoryProvider.runOnBackpacks((PlayerEntity)player, (backpack, inventoryName, slot) -> {
            BackpackContext.Item backpackContext = new BackpackContext.Item(inventoryName, slot);
            NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), backpack.func_200301_q()), backpackContext::toBuffer);
            return true;
        });
    }

    private static void openSubBackpack(ServerPlayerEntity player, BackpackOpenMessage msg, BackpackContainer backpackContainer) {
        BackpackContext backpackContext = backpackContainer.getBackpackContext().getSubBackpackContext(msg.subBackpackSlotIndex);
        ItemStack subBackpack = ((Slot)backpackContainer.field_75151_b.get(msg.subBackpackSlotIndex)).func_75211_c();
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), (ITextComponent)new StringTextComponent("... > " + subBackpack.func_200301_q().getString())), backpackContext::toBuffer);
    }

    private static void openParentBackpack(ServerPlayerEntity player, BackpackContainer backpackContainer) {
        BackpackContext backpackContext = backpackContainer.getBackpackContext().getParentBackpackContext();
        ItemStack parentBackpack = backpackContainer.getParentBackpackWrapper().getBackpack();
        NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)new SimpleNamedContainerProvider((w, p, pl) -> new BackpackContainer(w, pl, backpackContext), parentBackpack.func_200301_q()), backpackContext::toBuffer);
    }
}

