/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHelper;

public class SyncSlotStackMessage {
    private final int windowId;
    private final int slotNumber;
    private final ItemStack stack;

    public SyncSlotStackMessage(int windowId, int slotNumber, ItemStack stack) {
        this.windowId = windowId;
        this.slotNumber = slotNumber;
        this.stack = stack;
    }

    public static void encode(SyncSlotStackMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeByte(msg.windowId);
        packetBuffer.writeShort(msg.slotNumber);
        PacketHelper.writeItemStack(msg.stack, packetBuffer);
    }

    public static SyncSlotStackMessage decode(PacketBuffer packetBuffer) {
        return new SyncSlotStackMessage(packetBuffer.readUnsignedByte(), packetBuffer.readShort(), PacketHelper.readItemStack(packetBuffer));
    }

    static void onMessage(SyncSlotStackMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncSlotStackMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncSlotStackMessage msg) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || !(player.field_71070_bA instanceof BackpackContainer) || player.field_71070_bA.field_75152_c != msg.windowId) {
            return;
        }
        player.field_71070_bA.func_75141_a(msg.slotNumber, msg.stack);
    }
}

