/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SConfirmTransactionPacket;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.network.SyncContainerStacksMessage;

public class WindowClickMessage {
    private final int windowId;
    private final int slotNumber;
    private final int mouseButton;
    private final ClickType clickType;
    private final ItemStack clickedItem;
    private final short actionNumber;

    public WindowClickMessage(int windowId, int slotNumber, int mouseButton, ClickType clickType, ItemStack clickedItem, short actionNumber) {
        this.windowId = windowId;
        this.slotNumber = slotNumber;
        this.mouseButton = mouseButton;
        this.clickType = clickType;
        this.clickedItem = clickedItem;
        this.actionNumber = actionNumber;
    }

    public static void encode(WindowClickMessage msg, PacketBuffer packetBuffer) {
        packetBuffer.writeByte(msg.windowId);
        packetBuffer.writeShort(msg.slotNumber);
        packetBuffer.writeByte(msg.mouseButton);
        packetBuffer.func_179249_a((Enum)msg.clickType);
        PacketHelper.writeItemStack(msg.clickedItem, packetBuffer);
        packetBuffer.writeShort((int)msg.actionNumber);
    }

    public static WindowClickMessage decode(PacketBuffer packetBuffer) {
        return new WindowClickMessage(packetBuffer.readByte(), packetBuffer.readShort(), packetBuffer.readByte(), (ClickType)packetBuffer.func_179257_a(ClickType.class), PacketHelper.readItemStack(packetBuffer), packetBuffer.readShort());
    }

    static void onMessage(WindowClickMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> WindowClickMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayerEntity player, WindowClickMessage msg) {
        if (player == null || player.field_71070_bA.field_75152_c != msg.windowId || !(player.field_71070_bA instanceof BackpackContainer)) {
            return;
        }
        player.func_143004_u();
        if (player.func_175149_v()) {
            WindowClickMessage.syncSlotsForSpectator(player);
        } else {
            ItemStack stackClickResult = player.field_71070_bA.func_184996_a(msg.slotNumber, msg.mouseButton, msg.clickType, (PlayerEntity)player);
            if (ItemStack.func_77989_b((ItemStack)msg.clickedItem, (ItemStack)stackClickResult)) {
                player.field_71135_a.func_147359_a((IPacket)new SConfirmTransactionPacket(msg.windowId, msg.actionNumber, true));
                player.field_71137_h = true;
                player.field_71070_bA.func_75142_b();
                player.func_71113_k();
                player.field_71137_h = false;
            } else {
                player.field_71135_a.func_147359_a((IPacket)new SConfirmTransactionPacket(msg.windowId, msg.actionNumber, false));
                player.field_71070_bA.func_75128_a((PlayerEntity)player, false);
                NonNullList nonnulllist1 = NonNullList.func_191196_a();
                for (int j = 0; j < player.field_71070_bA.field_75151_b.size(); ++j) {
                    ItemStack itemstack = ((Slot)player.field_71070_bA.field_75151_b.get(j)).func_75211_c();
                    nonnulllist1.add((Object)(itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack));
                }
                player.func_71110_a(player.field_71070_bA, nonnulllist1);
            }
        }
    }

    private static void syncSlotsForSpectator(ServerPlayerEntity player) {
        NonNullList stacks = NonNullList.func_191196_a();
        for (int i = 0; i < player.field_71070_bA.field_75151_b.size(); ++i) {
            stacks.add((Object)((Slot)player.field_71070_bA.field_75151_b.get(i)).func_75211_c());
        }
        PacketHandler.sendToClient(player, new SyncContainerStacksMessage(player.field_71070_bA.field_75152_c, (List<ItemStack>)stacks));
    }
}

