/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogic {
    protected final ItemStack upgrade;
    private final Consumer<ItemStack> saveHandler;
    private final int filterSlotCount;
    private final Predicate<ItemStack> isItemValid;
    private final String parentTagKey;
    private FilterItemStackHandler filterHandler = null;
    private boolean allowListDefault = false;
    private boolean emptyAllowListMatchesEverything = false;

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount) {
        this(upgrade, saveHandler, filterSlotCount, s -> true, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid) {
        this(upgrade, saveHandler, filterSlotCount, isItemValid, "");
    }

    public FilterLogic(ItemStack upgrade, Consumer<ItemStack> saveHandler, int filterSlotCount, Predicate<ItemStack> isItemValid, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.filterSlotCount = filterSlotCount;
        this.isItemValid = isItemValid;
        this.parentTagKey = parentTagKey;
    }

    public void setEmptyAllowListMatchesEverything() {
        this.emptyAllowListMatchesEverything = true;
    }

    public void setAllowByDefault() {
        this.allowListDefault = true;
    }

    public FilterItemStackHandler getFilterHandler() {
        if (this.filterHandler == null) {
            this.filterHandler = new FilterItemStackHandler(this.filterSlotCount){

                @Override
                protected void onContentsChanged(int slot) {
                    super.onContentsChanged(slot);
                    NBTHelper.setCompoundNBT(FilterLogic.this.upgrade, FilterLogic.this.parentTagKey, "filters", this.serializeNBT());
                    FilterLogic.this.save();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    this.setSize(FilterLogic.this.filterSlotCount);
                    ListNBT tagList = nbt.func_150295_c("Items", 10);
                    for (int i = 0; i < tagList.size(); ++i) {
                        CompoundNBT itemTags = tagList.func_150305_b(i);
                        int slot = itemTags.func_74762_e("Slot");
                        if (slot < 0 || slot >= this.stacks.size()) continue;
                        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
                        this.stacks.set(slot, (Object)stack);
                    }
                    this.onLoad();
                }

                public boolean isItemValid(int slot, ItemStack stack) {
                    return stack.func_190926_b() || this.doesNotContain(stack) && FilterLogic.this.isItemValid.test(stack);
                }

                private boolean doesNotContain(ItemStack stack) {
                    return !InventoryHelper.hasItem((IItemHandler)this, s -> ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)stack));
                }
            };
            NBTHelper.getCompound(this.upgrade, this.parentTagKey, "filters").ifPresent(arg_0 -> ((FilterItemStackHandler)this.filterHandler).deserializeNBT(arg_0));
        }
        return this.filterHandler;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean matchesFilter(ItemStack stack) {
        if (this.isAllowList()) {
            return this.getFilterHandler().hasOnlyEmptyFilters() && this.emptyAllowListMatchesEverything || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> this.stackMatchesFilter(stack, (ItemStack)filter), () -> false, returnValue -> returnValue) != false;
        }
        return this.getFilterHandler().hasOnlyEmptyFilters() || InventoryHelper.iterate((IItemHandler)this.getFilterHandler(), (slot, filter) -> !this.stackMatchesFilter(stack, (ItemStack)filter), () -> true, returnValue -> returnValue == false) != false;
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.func_190926_b()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !stack.func_77973_b().getRegistryName().func_110624_b().equals(filter.func_77973_b().getRegistryName().func_110624_b()) : (primaryMatch == PrimaryMatch.ITEM ? !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)filter) : primaryMatch == PrimaryMatch.TAGS && !InventoryHelper.anyStackTagMatches(stack, filter))) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.func_77952_i() != filter.func_77952_i()) {
            return false;
        }
        return !this.shouldMatchNbt() || this.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    private boolean areItemStackTagsEqualIgnoreDurability(ItemStack stackA, ItemStack stackB) {
        if (stackA.func_190926_b() && stackB.func_190926_b()) {
            return true;
        }
        if (!stackA.func_190926_b() && !stackB.func_190926_b()) {
            if (stackA.func_77978_p() == null && stackB.func_77978_p() != null) {
                return false;
            }
            return (stackA.func_77978_p() == null || this.areTagsEqualIgnoreDurability(stackA.func_77978_p(), stackB.func_77978_p())) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    private boolean areTagsEqualIgnoreDurability(CompoundNBT tagA, @Nullable CompoundNBT tagB) {
        if (tagA == tagB) {
            return true;
        }
        if (tagB == null || tagA.func_186856_d() != tagB.func_186856_d()) {
            return false;
        }
        for (String key : tagA.func_150296_c()) {
            if (!tagB.func_74764_b(key)) {
                return false;
            }
            if (key.equals("Damage") || Objects.equals(tagA.func_74781_a(key), tagB.func_74781_a(key))) continue;
            return false;
        }
        return true;
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }
}

