/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.FilterSlotItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedbackpacks.util.FilterItemStackHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class FilterLogicContainer<T extends FilterLogic> {
    private static final String DATA_IS_ALLOW_LIST = "isAllowList";
    private static final String DATA_MATCH_DURABILITY = "matchDurability";
    private static final String DATA_MATCH_NBT = "matchNbt";
    private static final String DATA_PRIMARY_MATCH = "primaryMatch";
    protected final IServerUpdater serverUpdater;
    protected final Supplier<T> filterLogic;
    private final List<FilterLogicSlot> filterSlots = new ArrayList<FilterLogicSlot>();

    public FilterLogicContainer(Supplier<T> filterLogic, IServerUpdater serverUpdater, Consumer<Slot> addSlot) {
        this.filterLogic = filterLogic;
        this.serverUpdater = serverUpdater;
        FilterItemStackHandler filterHandler = ((FilterLogic)filterLogic.get()).getFilterHandler();
        InventoryHelper.iterate((IItemHandler)filterHandler, (slot, stack) -> {
            FilterLogicSlot filterSlot = new FilterLogicSlot(() -> FilterLogicContainer.lambda$new$0((Supplier)filterLogic), (Integer)slot);
            addSlot.accept((Slot)filterSlot);
            this.filterSlots.add(filterSlot);
        });
    }

    public boolean isAllowList() {
        return ((FilterLogic)this.filterLogic.get()).isAllowList();
    }

    public boolean shouldMatchDurability() {
        return ((FilterLogic)this.filterLogic.get()).shouldMatchDurability();
    }

    public boolean shouldMatchNbt() {
        return ((FilterLogic)this.filterLogic.get()).shouldMatchNbt();
    }

    public PrimaryMatch getPrimaryMatch() {
        return ((FilterLogic)this.filterLogic.get()).getPrimaryMatch();
    }

    public void setAllowList(boolean isAllowList) {
        ((FilterLogic)this.filterLogic.get()).setAllowList(isAllowList);
        this.serverUpdater.sendBooleanToServer(DATA_IS_ALLOW_LIST, isAllowList);
    }

    public void setMatchDurability(boolean matchDurability) {
        ((FilterLogic)this.filterLogic.get()).setMatchDurability(matchDurability);
        this.serverUpdater.sendBooleanToServer(DATA_MATCH_DURABILITY, matchDurability);
    }

    public void setMatchNbt(boolean matchNbt) {
        ((FilterLogic)this.filterLogic.get()).setMatchNbt(matchNbt);
        this.serverUpdater.sendBooleanToServer(DATA_MATCH_NBT, matchNbt);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        ((FilterLogic)this.filterLogic.get()).setPrimaryMatch(primaryMatch);
        this.serverUpdater.sendDataToServer(() -> NBTHelper.putEnumConstant(new CompoundNBT(), DATA_PRIMARY_MATCH, primaryMatch));
    }

    public boolean handleMessage(CompoundNBT data) {
        Iterator iterator = data.func_150296_c().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "isAllowList": {
                    this.setAllowList(data.func_74767_n(DATA_IS_ALLOW_LIST));
                    return true;
                }
                case "matchDurability": {
                    this.setMatchDurability(data.func_74767_n(DATA_MATCH_DURABILITY));
                    return true;
                }
                case "matchNbt": {
                    this.setMatchNbt(data.func_74767_n(DATA_MATCH_NBT));
                    return true;
                }
                case "primaryMatch": {
                    this.setPrimaryMatch(PrimaryMatch.fromName(data.func_74779_i(DATA_PRIMARY_MATCH)));
                    return true;
                }
            }
        }
        return false;
    }

    public List<FilterLogicSlot> getFilterSlots() {
        return this.filterSlots;
    }

    private static /* synthetic */ IItemHandler lambda$new$0(Supplier filterLogic) {
        return ((FilterLogic)filterLogic.get()).getFilterHandler();
    }

    public static class FilterLogicSlot
    extends FilterSlotItemHandler {
        private boolean enabled = true;

        public FilterLogicSlot(Supplier<IItemHandler> filterHandler, Integer slot) {
            super(filterHandler, slot, -100, -100);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean func_111238_b() {
            return this.enabled;
        }
    }
}

