/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.container.Slot;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.GuiHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.Position;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ButtonDefinitions;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.CompositeWidget;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.ToggleButton;
import net.p3pp3rf1y.sophisticatedbackpacks.client.gui.controls.Widget;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogicContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.PrimaryMatch;

public class FilterLogicControl<L extends FilterLogic, C extends FilterLogicContainer<L>>
extends CompositeWidget<Widget> {
    protected final C container;
    private final Button[] showButtons;
    private final int height;
    private final int width;
    private final int slotsTopYOffset;
    private final int slotsPerRow;
    private final int slotsInExtraRow;
    private final int fullSlotRows;

    public FilterLogicControl(Position position, C filterLogicContainer, int slotsPerRow, Button ... showButtons) {
        this(position, filterLogicContainer, slotsPerRow, showButtons.length > 0, showButtons);
    }

    protected FilterLogicControl(Position position, C filterLogicContainer, int slotsPerRow, boolean buttonsVisible, Button ... showButtons) {
        super(position);
        this.container = filterLogicContainer;
        this.slotsPerRow = slotsPerRow;
        this.showButtons = showButtons;
        if (this.shouldShow(Button.ALLOW_LIST)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x, this.y), ButtonDefinitions.ALLOW_LIST, button -> ((FilterLogicContainer)this.container).setAllowList(!((FilterLogicContainer)this.container).isAllowList()), () -> this.container.isAllowList()));
        }
        if (this.shouldShow(Button.PRIMARY_MATCH)) {
            this.addChild(new ToggleButton<PrimaryMatch>(new Position(this.x + 18, this.y), ButtonDefinitions.PRIMARY_MATCH, button -> ((FilterLogicContainer)this.container).setPrimaryMatch(((FilterLogicContainer)this.container).getPrimaryMatch().next()), () -> this.container.getPrimaryMatch()));
        }
        if (this.shouldShow(Button.DURABILITY)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x + 36, this.y), ButtonDefinitions.MATCH_DURABILITY, button -> ((FilterLogicContainer)this.container).setMatchDurability(!((FilterLogicContainer)this.container).shouldMatchDurability()), () -> this.container.shouldMatchDurability()));
        }
        if (this.shouldShow(Button.NBT)) {
            this.addChild(new ToggleButton<Boolean>(new Position(this.x + 54, this.y), ButtonDefinitions.MATCH_NBT, button -> ((FilterLogicContainer)this.container).setMatchNbt(!((FilterLogicContainer)this.container).shouldMatchNbt()), () -> this.container.shouldMatchNbt()));
        }
        this.width = Math.max(slotsPerRow * 18, this.getMaxButtonWidth());
        this.slotsTopYOffset = buttonsVisible ? 21 : 0;
        this.fullSlotRows = ((FilterLogicContainer)this.container).getFilterSlots().size() / slotsPerRow;
        this.slotsInExtraRow = ((FilterLogicContainer)this.container).getFilterSlots().size() % slotsPerRow;
        this.height = (this.fullSlotRows + (this.slotsInExtraRow > 0 ? 1 : 0)) * 18 + this.slotsTopYOffset;
    }

    private int getMaxButtonWidth() {
        int maxWidth = 0;
        for (Widget w : this.children) {
            int buttonWidth = w.getX() + w.getWidth() - this.x;
            if (buttonWidth <= maxWidth) continue;
            maxWidth = buttonWidth;
        }
        return maxWidth;
    }

    private boolean shouldShow(Button button) {
        for (Button showButton : this.showButtons) {
            if (showButton != button) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void renderBg(MatrixStack matrixStack, Minecraft minecraft, int mouseX, int mouseY) {
        GuiHelper.renderSlotsBackground(minecraft, matrixStack, this.x, this.y + this.slotsTopYOffset, this.slotsPerRow, this.fullSlotRows, this.slotsInExtraRow);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public void moveSlotsToView(int screenGuiLeft, int screenGuiTop) {
        int upgradeSlotNumber = 0;
        for (Slot slot : ((FilterLogicContainer)this.container).getFilterSlots()) {
            slot.field_75223_e = this.x - screenGuiLeft + 1 + upgradeSlotNumber % this.slotsPerRow * 18;
            slot.field_75221_f = this.y - screenGuiTop + this.slotsTopYOffset + 1 + upgradeSlotNumber / this.slotsPerRow * 18;
            ++upgradeSlotNumber;
        }
    }

    public static enum Button {
        ALLOW_LIST,
        PRIMARY_MATCH,
        DURABILITY,
        NBT;

    }

    public static class Advanced
    extends FilterLogicControl<FilterLogic, FilterLogicContainer<FilterLogic>> {
        public Advanced(Position position, FilterLogicContainer<FilterLogic> filterLogicContainer, int slotsPerRow) {
            super(position, filterLogicContainer, slotsPerRow, Button.ALLOW_LIST, Button.PRIMARY_MATCH, Button.DURABILITY, Button.NBT);
        }
    }

    public static class Basic
    extends FilterLogicControl<FilterLogic, FilterLogicContainer<FilterLogic>> {
        public Basic(Position position, FilterLogicContainer<FilterLogic> filterLogicContainer, int slotsPerRow) {
            super(position, filterLogicContainer, slotsPerRow, Button.ALLOW_LIST);
        }
    }
}

