/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IFilteredUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.feeding.FeedingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class FeedingUpgradeWrapper
extends UpgradeWrapperBase<FeedingUpgradeWrapper, FeedingUpgradeItem>
implements ITickableUpgrade,
IFilteredUpgrade {
    private static final int COOLDOWN = 100;
    private static final int FEEDING_RANGE = 3;
    private final FilterLogic filterLogic;

    public FeedingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.filterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.feedingUpgrade.filterSlots.get(), ItemStack::func_222117_E);
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world) || entity != null && !(entity instanceof PlayerEntity)) {
            return;
        }
        if (entity == null) {
            world.func_217394_a(EntityType.field_200729_aH, new AxisAlignedBB(pos).func_186662_g(3.0), p -> true).forEach(p -> this.feedPlayer((PlayerEntity)p, world));
        } else {
            this.feedPlayer((PlayerEntity)entity, world);
        }
        this.setCooldown(world, 100);
    }

    private void feedPlayer(PlayerEntity player, World world) {
        int hungerLevel = 20 - player.func_71024_bL().func_75116_a();
        if (hungerLevel == 0) {
            return;
        }
        this.tryFeedingFoodFromBackpack(world, hungerLevel, player);
    }

    private void tryFeedingFoodFromBackpack(World world, int hungerLevel, PlayerEntity player) {
        boolean isHurt = player.func_110143_aJ() < player.func_110138_aP() - 1.0f;
        IItemHandlerModifiable inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        InventoryHelper.iterate((IItemHandler)inventory, (slot, stack) -> {
            if (stack.func_222117_E() && this.filterLogic.matchesFilter((ItemStack)stack) && (stack.func_77973_b().func_219967_s().func_221466_a() / 2 < hungerLevel || hungerLevel > 0 && isHurt)) {
                ItemStack containerItem = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)stack.func_77946_l(), (int)0, (ItemStack)stack.func_77973_b().func_77654_b(stack, world, (LivingEntity)player));
                inventory.setStackInSlot(slot.intValue(), stack);
                if (containerItem != stack) {
                    player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).ifPresent(playerInventory -> InventoryHelper.insertOrDropItem(player, containerItem, new IItemHandler[]{inventory, playerInventory}));
                }
                return true;
            }
            return false;
        }, () -> false, ret -> ret);
    }

    @Override
    public FilterLogic getFilterLogic() {
        return this.filterLogic;
    }
}

