/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception;

import java.util.function.Consumer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IInventoryWrapperUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IUpgradeAccessModifier;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IUpgradeWrapperAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InceptionWrapperAccessor;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.InventoryOrder;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.inception.SubBackpacksHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;

public class InceptionUpgradeWrapper
extends UpgradeWrapperBase<InceptionUpgradeWrapper, InceptionUpgradeItem>
implements IInventoryWrapperUpgrade,
IUpgradeAccessModifier {
    private SubBackpacksHandler subBackpacksHandler = null;

    public InceptionUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
    }

    @Override
    public boolean hideSettingsTab() {
        return Boolean.FALSE.equals(Config.COMMON.inceptionUpgrade.upgradesUseInventoriesOfBackpacksInBackpack.get());
    }

    public InventoryOrder getInventoryOrder() {
        return NBTHelper.getEnumConstant(this.upgrade, "inventoryOrder", InventoryOrder::fromName).orElse(InventoryOrder.MAIN_FIRST);
    }

    public void setInventoryOrder(InventoryOrder inventoryOrder) {
        NBTHelper.setEnumConstant(this.upgrade, "inventoryOrder", inventoryOrder);
        this.save();
        this.backpackWrapper.refreshInventoryForUpgradeProcessing();
    }

    @Override
    public IItemHandlerModifiable wrapInventory(IItemHandlerModifiable inventory) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesUseInventoriesOfBackpacksInBackpack.get())) {
            this.initSubBackpacksHandler();
            return new InceptionInventoryHandler(inventory, this.getInventoryOrder(), this.subBackpacksHandler);
        }
        return inventory;
    }

    private void initSubBackpacksHandler() {
        this.subBackpacksHandler = new SubBackpacksHandler(this.backpackWrapper.getInventoryHandler());
    }

    @Override
    public IUpgradeWrapperAccessor wrapAccessor(IUpgradeWrapperAccessor upgradeWrapperAccessor) {
        if (Boolean.TRUE.equals(Config.COMMON.inceptionUpgrade.upgradesInContainedBackpacksAreFunctional.get())) {
            this.initSubBackpacksHandler();
            return new InceptionWrapperAccessor(this.backpackWrapper, this.subBackpacksHandler);
        }
        return upgradeWrapperAccessor;
    }
}

