/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.EntityTickableSound;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.TickEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.jukebox.SoundStopNotificationMessage;

public class BackpackSoundHandler {
    private static final int SOUND_STOP_CHECK_INTERVAL = 10;
    private static final Map<UUID, ISound> backpackSounds = new HashMap<UUID, ISound>();
    private static long lastPlaybackChecked = 0L;

    private BackpackSoundHandler() {
    }

    public static void playBackpackSound(UUID backpackUuid, ISound sound) {
        BackpackSoundHandler.stopBackpackSound(backpackUuid);
        backpackSounds.put(backpackUuid, sound);
        Minecraft.func_71410_x().func_147118_V().func_147682_a(sound);
    }

    public static void stopBackpackSound(UUID backpackUuid) {
        if (backpackSounds.containsKey(backpackUuid)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b(backpackSounds.remove(backpackUuid));
            PacketHandler.sendToServer(new SoundStopNotificationMessage(backpackUuid));
        }
    }

    public static void tick(TickEvent.WorldTickEvent event) {
        if (!backpackSounds.isEmpty() && lastPlaybackChecked < event.world.func_82737_E() - 10L) {
            lastPlaybackChecked = event.world.func_82737_E();
            backpackSounds.entrySet().removeIf(entry -> {
                if (!Minecraft.func_71410_x().func_147118_V().func_215294_c((ISound)entry.getValue())) {
                    PacketHandler.sendToServer(new SoundStopNotificationMessage((UUID)entry.getKey()));
                    return true;
                }
                return false;
            });
        }
    }

    public static void playBackpackSound(SoundEvent soundEvent, UUID backpackUuid, BlockPos pos) {
        BackpackSoundHandler.playBackpackSound(backpackUuid, (ISound)SimpleSound.func_184372_a((SoundEvent)soundEvent, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()));
    }

    public static void playBackpackSound(SoundEvent soundEvent, UUID backpackUuid, int entityId) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(entityId);
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        BackpackSoundHandler.playBackpackSound(backpackUuid, (ISound)new EntityTickableSound(soundEvent, SoundCategory.RECORDS, 2.0f, 1.0f, entity));
    }
}

