/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedbackpacks.Config;
import net.p3pp3rf1y.sophisticatedbackpacks.api.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.api.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.FilterLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.UpgradeWrapperBase;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.AutoSmeltingUpgradeItem;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.ISmeltingUpgrade;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.smelting.SmeltingLogic;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class AutoSmeltingUpgradeWrapper
extends UpgradeWrapperBase<AutoSmeltingUpgradeWrapper, AutoSmeltingUpgradeItem>
implements ITickableUpgrade,
ISmeltingUpgrade {
    private static final int NOTHING_TO_DO_COOLDOWN = 10;
    private static final int NO_INVENTORY_SPACE_COOLDOWN = 60;
    private final FilterLogic inputFilterLogic;
    private final FilterLogic fuelFilterLogic;
    private final SmeltingLogic smeltingLogic;
    private final Predicate<ItemStack> isValidInput;
    private final Predicate<ItemStack> isValidFuel;
    private int outputCooldown = 0;
    private int fuelCooldown = 0;
    private int inputCooldown = 0;

    public AutoSmeltingUpgradeWrapper(IBackpackWrapper backpackWrapper, ItemStack upgrade, Consumer<ItemStack> upgradeSaveHandler) {
        super(backpackWrapper, upgrade, upgradeSaveHandler);
        this.inputFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.autoSmeltingUpgrade.inputFilterSlots.get(), s -> RecipeHelper.getSmeltingRecipe(s).isPresent(), "inputFilter");
        this.fuelFilterLogic = new FilterLogic(upgrade, upgradeSaveHandler, (Integer)Config.COMMON.autoSmeltingUpgrade.fuelFilterSlots.get(), s -> ForgeHooks.getBurnTime((ItemStack)s) > 0, "fuelFilter");
        this.fuelFilterLogic.setAllowByDefault();
        this.fuelFilterLogic.setEmptyAllowListMatchesEverything();
        this.isValidInput = s -> RecipeHelper.getSmeltingRecipe(s).isPresent() && this.inputFilterLogic.matchesFilter((ItemStack)s);
        this.isValidFuel = s -> ForgeHooks.getBurnTime((ItemStack)s) > 0 && this.fuelFilterLogic.matchesFilter((ItemStack)s);
        this.smeltingLogic = new SmeltingLogic(upgrade, upgradeSaveHandler, this.isValidFuel, this.isValidInput, (Double)Config.COMMON.autoSmeltingUpgrade.smeltingSpeedMultiplier.get(), (Double)Config.COMMON.autoSmeltingUpgrade.fuelEfficiencyMultiplier.get());
    }

    private void tryPushingOutput() {
        if (this.outputCooldown > 0) {
            --this.outputCooldown;
            return;
        }
        ItemStack output = this.smeltingLogic.getCookOutput();
        IItemHandlerModifiable inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (!output.func_190926_b() && InventoryHelper.insertIntoInventory(output, (IItemHandler)inventory, true).func_190916_E() < output.func_190916_E()) {
            ItemStack ret = InventoryHelper.insertIntoInventory(output, (IItemHandler)inventory, false);
            this.smeltingLogic.getSmeltingInventory().extractItem(2, output.func_190916_E() - ret.func_190916_E(), false);
        } else {
            this.outputCooldown = 60;
        }
        ItemStack fuel = this.smeltingLogic.getFuel();
        if (!fuel.func_190926_b() && ForgeHooks.getBurnTime((ItemStack)fuel) <= 0 && InventoryHelper.insertIntoInventory(fuel, (IItemHandler)inventory, true).func_190916_E() < fuel.func_190916_E()) {
            ItemStack ret = InventoryHelper.insertIntoInventory(fuel, (IItemHandler)inventory, false);
            this.smeltingLogic.getSmeltingInventory().extractItem(1, fuel.func_190916_E() - ret.func_190916_E(), false);
        }
    }

    @Override
    public void tick(@Nullable LivingEntity entity, World world, BlockPos pos) {
        if (this.isInCooldown(world)) {
            return;
        }
        this.tryPushingOutput();
        this.tryPullingFuel();
        this.tryPullingInput();
        if (!this.smeltingLogic.tick(world) && this.outputCooldown <= 0 && this.fuelCooldown <= 0 && this.inputCooldown <= 0) {
            this.setCooldown(world, 10);
        }
    }

    private void tryPullingInput() {
        if (this.inputCooldown > 0) {
            --this.inputCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.smeltingLogic.getCookInput(), this.smeltingLogic::setCookInput, this.isValidInput)) {
            this.inputCooldown = 60;
        }
    }

    private void tryPullingFuel() {
        if (this.fuelCooldown > 0) {
            --this.fuelCooldown;
            return;
        }
        if (this.tryPullingGetUnsucessful(this.smeltingLogic.getFuel(), this.smeltingLogic::setFuel, this.isValidFuel)) {
            this.fuelCooldown = 60;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryPullingGetUnsucessful(ItemStack stack, Consumer<ItemStack> setSlot, Predicate<ItemStack> isItemValid) {
        ItemStack toExtract;
        IItemHandlerModifiable inventory = this.backpackWrapper.getInventoryForUpgradeProcessing();
        if (stack.func_190926_b()) {
            AtomicReference<ItemStack> ret = new AtomicReference<ItemStack>(ItemStack.field_190927_a);
            InventoryHelper.iterate((IItemHandler)inventory, (slot, st) -> {
                if (isItemValid.test((ItemStack)st)) {
                    ret.set(st.func_77946_l());
                }
            }, () -> !((ItemStack)ret.get()).func_190926_b());
            if (ret.get().func_190926_b()) return true;
            toExtract = ret.get();
            toExtract.func_190920_e(toExtract.func_77976_d());
        } else {
            if (stack.func_190916_E() == stack.func_77976_d() || !isItemValid.test(stack)) {
                return true;
            }
            toExtract = stack.func_77946_l();
            toExtract.func_190920_e(stack.func_77976_d() - stack.func_190916_E());
        }
        if (InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, true).func_190916_E() <= 0) {
            return true;
        }
        ItemStack toSet = InventoryHelper.extractFromInventory(toExtract, (IItemHandler)inventory, false);
        toSet.func_190917_f(stack.func_190916_E());
        setSlot.accept(toSet);
        return false;
    }

    @Override
    public SmeltingLogic getSmeltingLogic() {
        return this.smeltingLogic;
    }

    public FilterLogic getInputFilterLogic() {
        return this.inputFilterLogic;
    }

    public FilterLogic getFuelFilterLogic() {
        return this.fuelFilterLogic;
    }
}

