/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.UUIDCodec;

public class NBTHelper {
    private NBTHelper() {
    }

    public static Optional<Integer> getInt(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74762_e);
    }

    private static <T> Optional<T> getTagValue(ItemStack stack, String key, BiFunction<CompoundNBT, String, T> getValue) {
        return NBTHelper.getTagValue(stack, "", key, getValue);
    }

    private static <T> Optional<T> getTagValue(ItemStack stack, String parentKey, String key, BiFunction<CompoundNBT, String, T> getValue) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag == null) {
            return Optional.empty();
        }
        if (!parentKey.isEmpty()) {
            INBT parentTag = tag.func_74781_a(parentKey);
            if (!(parentTag instanceof CompoundNBT)) {
                return Optional.empty();
            }
            tag = (CompoundNBT)parentTag;
        }
        if (!tag.func_74764_b(key)) {
            return Optional.empty();
        }
        return Optional.of(getValue.apply(tag, key));
    }

    public static Optional<CompoundNBT> getCompound(ItemStack stack, String parentKey, String tagName) {
        return NBTHelper.getTagValue(stack, parentKey, tagName, CompoundNBT::func_74775_l);
    }

    public static Optional<CompoundNBT> getCompound(ItemStack stack, String tagName) {
        return NBTHelper.getTagValue(stack, tagName, CompoundNBT::func_74775_l);
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String parentKey, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, parentKey, key, (t, k) -> (Enum)deserialize.apply(t.func_74779_i(k)));
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, key, (t, k) -> (Enum)deserialize.apply(t.func_74779_i(k)));
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String parentKey, String key) {
        return NBTHelper.getTagValue(stack, parentKey, key, CompoundNBT::func_74767_n);
    }

    public static Optional<Boolean> getBoolean(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74767_n);
    }

    public static Optional<Long> getLong(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74763_f);
    }

    public static Optional<UUID> getUniqueId(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, (compound, k) -> NBTUtil.func_186860_b((INBT)compound.func_74781_a(k)));
    }

    public static void setCompoundNBT(ItemStack stack, String key, CompoundNBT tag) {
        NBTHelper.setCompoundNBT(stack, "", key, tag);
    }

    public static void setCompoundNBT(ItemStack stack, String parentKey, String key, CompoundNBT tag) {
        if (parentKey.isEmpty()) {
            stack.func_196082_o().func_218657_a(key, (INBT)tag);
            return;
        }
        stack.func_190925_c(parentKey).func_218657_a(key, (INBT)tag);
    }

    public static void setBoolean(ItemStack stack, String parentKey, String key, boolean value) {
        if (parentKey.isEmpty()) {
            NBTHelper.setBoolean(stack, key, value);
            return;
        }
        NBTHelper.putBoolean(stack.func_190925_c(parentKey), key, value);
    }

    public static void setBoolean(ItemStack stack, String key, boolean value) {
        NBTHelper.putBoolean(stack.func_196082_o(), key, value);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String parentKey, String key, T enumConstant) {
        if (parentKey.isEmpty()) {
            NBTHelper.setEnumConstant(stack, key, enumConstant);
            return;
        }
        NBTHelper.putEnumConstant(stack.func_190925_c(parentKey), key, enumConstant);
    }

    public static <T extends Enum<T>> void setEnumConstant(ItemStack stack, String key, T enumConstant) {
        NBTHelper.putEnumConstant(stack.func_196082_o(), key, enumConstant);
    }

    public static CompoundNBT putBoolean(CompoundNBT tag, String key, boolean value) {
        tag.func_74757_a(key, value);
        return tag;
    }

    public static CompoundNBT putInt(CompoundNBT tag, String key, int value) {
        tag.func_74768_a(key, value);
        return tag;
    }

    public static CompoundNBT putString(CompoundNBT tag, String key, String value) {
        tag.func_74778_a(key, value);
        return tag;
    }

    public static <T extends Enum<T>> CompoundNBT putEnumConstant(CompoundNBT tag, String key, T enumConstant) {
        tag.func_74778_a(key, ((IStringSerializable)enumConstant).func_176610_l());
        return tag;
    }

    public static void setLong(ItemStack stack, String key, long value) {
        stack.func_196082_o().func_74772_a(key, value);
    }

    public static void setInteger(ItemStack stack, String key, int value) {
        stack.func_196082_o().func_74768_a(key, value);
    }

    public static void setUniqueId(ItemStack stack, String key, UUID uuid) {
        stack.func_196082_o().func_74783_a(key, UUIDCodec.func_239777_a_((UUID)uuid));
    }

    public static void removeTag(ItemStack stack, String key) {
        if (stack.func_77978_p() == null) {
            return;
        }
        stack.func_77978_p().func_82580_o(key);
    }

    public static Optional<String> getString(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74779_i);
    }

    public static Optional<Float> getFloat(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundNBT::func_74760_g);
    }
}

