/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.InventoryHelper;

public class RecipeHelper {
    private static final Map<Item, Set<CompactingShape>> ITEM_COMPACTING_SHAPES = new HashMap<Item, Set<CompactingShape>>();
    private static WeakReference<World> world;

    private RecipeHelper() {
    }

    public static void setWorld(World w) {
        world = new WeakReference<World>(w);
    }

    private static Optional<World> getWorld() {
        return Optional.ofNullable((World)world.get());
    }

    private static Set<CompactingShape> getCompactingShapes(Item item) {
        return RecipeHelper.getWorld().map(w -> {
            HashSet<CompactingShape> compactingShapes = new HashSet<CompactingShape>();
            ItemStack compactingResult = RecipeHelper.getCraftingResultAndRemainingItems(item, w, 2, 2, new ArrayList<ItemStack>());
            if (!compactingResult.func_190926_b()) {
                if (RecipeHelper.uncompactMatchesItem(compactingResult, w, item, 4)) {
                    compactingShapes.add(CompactingShape.TWO_BY_TWO_UNCRAFTABLE);
                } else {
                    compactingShapes.add(CompactingShape.TWO_BY_TWO);
                }
            }
            if (!(compactingResult = RecipeHelper.getCraftingResultAndRemainingItems(item, w, 3, 3, new ArrayList<ItemStack>())).func_190926_b()) {
                if (RecipeHelper.uncompactMatchesItem(compactingResult, w, item, 9)) {
                    compactingShapes.add(CompactingShape.THREE_BY_THREE_UNCRAFTABLE);
                } else {
                    compactingShapes.add(CompactingShape.THREE_BY_THREE);
                }
            }
            return compactingShapes;
        }).orElse(Collections.emptySet());
    }

    private static boolean uncompactMatchesItem(ItemStack result, World w, Item item, int count) {
        return ((result = RecipeHelper.getCraftingResultAndRemainingItems(result.func_77973_b(), w, 1, 1, new ArrayList<ItemStack>())).func_77973_b() == item || InventoryHelper.anyItemTagMatches(result.func_77973_b(), item)) && result.func_190916_E() == count;
    }

    public static ItemStack getCraftingResultAndRemainingItems(Item item, int width, int height, List<ItemStack> remainingItems) {
        return RecipeHelper.getWorld().map(w -> RecipeHelper.getCraftingResultAndRemainingItems(item, w, width, height, remainingItems)).orElse(ItemStack.field_190927_a);
    }

    private static ItemStack getCraftingResultAndRemainingItems(Item item, World w, int width, int height, List<ItemStack> remainingItems) {
        CraftingInventory craftingInventory = RecipeHelper.getFilledCraftingInventory(item, width, height);
        return w.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, w).map(r -> {
            r.func_179532_b((IInventory)craftingInventory).forEach(stack -> {
                if (!stack.func_190926_b()) {
                    remainingItems.add((ItemStack)stack);
                }
            });
            return r.func_77572_b((IInventory)craftingInventory);
        }).orElse(ItemStack.field_190927_a);
    }

    private static CraftingInventory getFilledCraftingInventory(Item item, int width, int height) {
        CraftingInventory craftinginventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity playerIn) {
                return false;
            }
        }, width, height);
        for (int i = 0; i < craftinginventory.func_70302_i_(); ++i) {
            craftinginventory.func_70299_a(i, new ItemStack((IItemProvider)item));
        }
        return craftinginventory;
    }

    public static Optional<FurnaceRecipe> getSmeltingRecipe(ItemStack stack) {
        return RecipeHelper.getWorld().flatMap(w -> w.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{stack}))), w));
    }

    public static Set<CompactingShape> getItemCompactingShapes(Item item) {
        return ITEM_COMPACTING_SHAPES.computeIfAbsent(item, RecipeHelper::getCompactingShapes);
    }

    public static List<StonecuttingRecipe> getStonecuttingRecipes(IInventory inventory) {
        return RecipeHelper.getWorld().map(w -> w.func_199532_z().func_215370_b(IRecipeType.field_222154_f, inventory, w)).orElse(Collections.emptyList());
    }

    public static enum CompactingShape {
        NONE,
        THREE_BY_THREE,
        TWO_BY_TWO,
        THREE_BY_THREE_UNCRAFTABLE,
        TWO_BY_TWO_UNCRAFTABLE;

    }
}

