/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.savetools;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamfruit.savetools.ChatUtil;
import net.teamfruit.savetools.Config;
import org.lwjgl.glfw.GLFW;

public class InputHandler {
    public static final InputHandler INSTANCE = new InputHandler();
    public static final KeyBinding KEY_TOGGLE = new KeyBinding("key.savetools.toggle", 66, "key.savetools.category");
    public static final KeyBinding KEY_CONFIG = new KeyBinding("key.savetools.config", -1, "key.savetools.category");
    private boolean enabled = true;
    private boolean autoEnable = true;
    private int slot = -1;
    private ItemStack item = null;

    private InputHandler() {
    }

    @SubscribeEvent
    public void onInput(InputEvent event) {
        if (KEY_TOGGLE.func_151468_f()) {
            if (this.enabled) {
                this.disable(!this.isShiftPressed());
            } else {
                this.enable();
            }
        }
        if (KEY_CONFIG.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a(Config.INSTANCE.buildClothConfig(Minecraft.func_71410_x().field_71462_r));
        }
    }

    public void onTick() {
        if (Minecraft.func_71410_x().field_71439_g == null || this.isEnabled() || !this.autoEnable) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!(player == null || this.slot == player.field_71071_by.field_70461_c && ItemStack.func_185132_d((ItemStack)this.item, (ItemStack)player.func_184614_ca()))) {
            this.enableAuto();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        this.enabled = true;
        ChatUtil.saveToolsMessage(new TranslationTextComponent("message.savetools.enabled.manually", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }

    private void enableAuto() {
        this.enabled = true;
        ChatUtil.saveToolsMessage(new TranslationTextComponent("message.savetools.enabled.auto", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
    }

    public void disable(boolean autoEnable) {
        this.enabled = false;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (autoEnable && player != null) {
            this.autoEnable = true;
            this.slot = player.field_71071_by.field_70461_c;
            this.item = player.func_184614_ca();
            ChatUtil.saveToolsMessage(new TranslationTextComponent("message.savetools.disabled.temporary", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        } else {
            this.autoEnable = false;
            ChatUtil.saveToolsMessage(new TranslationTextComponent("message.savetools.disabled.while", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public boolean isShiftPressed() {
        long handle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
        return GLFW.glfwGetKey((long)handle, (int)340) == 1 || GLFW.glfwGetKey((long)handle, (int)344) == 1;
    }
}

