/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.forge.gui.entries;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.forge.gui.entries.TooltipListEntry;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;

@OnlyIn(value=Dist.CLIENT)
public abstract class TextFieldListEntry<T>
extends TooltipListEntry<T> {
    protected TextFieldWidget textFieldWidget;
    protected Button resetButton;
    protected Supplier<T> defaultValue;
    protected T original;
    protected List<IGuiEventListener> widgets;
    private boolean isSelected = false;

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue) {
        this(fieldName, original, resetButtonKey, defaultValue, null);
    }

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<ITextComponent[]>> tooltipSupplier) {
        this(fieldName, original, resetButtonKey, defaultValue, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    protected TextFieldListEntry(ITextComponent fieldName, T original, ITextComponent resetButtonKey, Supplier<T> defaultValue, Supplier<Optional<ITextComponent[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.defaultValue = defaultValue;
        this.original = original;
        this.textFieldWidget = new TextFieldWidget(Minecraft.func_71410_x().field_71466_p, 0, 0, 148, 18, NarratorChatListener.field_216868_a){

            public void func_230430_a_(MatrixStack matrices, int int_1, int int_2, float float_1) {
                this.func_146195_b(TextFieldListEntry.this.isSelected && TextFieldListEntry.this.func_241217_q_() == this);
                TextFieldListEntry.this.textFieldPreRender(this);
                super.func_230430_a_(matrices, int_1, int_2, float_1);
            }

            public void func_146191_b(String string_1) {
                super.func_146191_b(TextFieldListEntry.this.stripAddText(string_1));
            }
        };
        this.textFieldWidget.func_146203_f(999999);
        this.textFieldWidget.func_146180_a(String.valueOf(original));
        this.resetButton = new Button(0, 0, Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)resetButtonKey) + 6, 20, resetButtonKey, widget -> this.textFieldWidget.func_146180_a(String.valueOf(defaultValue.get())));
        this.widgets = Lists.newArrayList((Object[])new IGuiEventListener[]{this.textFieldWidget, this.resetButton});
    }

    @Override
    public boolean isEdited() {
        return this.isChanged(this.original, this.textFieldWidget.func_146179_b());
    }

    protected boolean isChanged(T original, String s) {
        return !String.valueOf(original).equals(s);
    }

    protected static void setTextFieldWidth(TextFieldWidget widget, int width) {
        widget.func_230991_b_(width);
    }

    @Deprecated
    public void setValue(String s) {
        this.textFieldWidget.func_146180_a(String.valueOf(s));
    }

    protected String stripAddText(String s) {
        return s;
    }

    protected void textFieldPreRender(TextFieldWidget widget) {
    }

    @Override
    public void updateSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Override
    public void render(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isSelected, delta);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.resetButton.field_230693_o_ = this.isEditable() && this.getDefaultValue().isPresent() && !this.isMatchDefault(this.textFieldWidget.func_146179_b());
        this.resetButton.field_230691_m_ = y;
        this.textFieldWidget.func_146184_c(this.isEditable());
        this.textFieldWidget.field_230691_m_ = y + 1;
        ITextComponent displayedFieldName = this.getDisplayedFieldName();
        if (Minecraft.func_71410_x().field_71466_p.func_78260_a()) {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)(window.func_198107_o() - x - Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)displayedFieldName)), (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x;
            this.textFieldWidget.field_230690_l_ = x + this.resetButton.func_230998_h_();
        } else {
            Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrices, displayedFieldName.func_241878_f(), (float)x, (float)(y + 5), this.getPreferredTextColor());
            this.resetButton.field_230690_l_ = x + entryWidth - this.resetButton.func_230998_h_();
            this.textFieldWidget.field_230690_l_ = x + entryWidth - 148;
        }
        TextFieldListEntry.setTextFieldWidth(this.textFieldWidget, 148 - this.resetButton.func_230998_h_() - 4);
        this.resetButton.func_230430_a_(matrices, mouseX, mouseY, delta);
        this.textFieldWidget.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    protected abstract boolean isMatchDefault(String var1);

    @Override
    public Optional<T> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.widgets;
    }
}

