/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.savetools;

import java.util.Arrays;
import java.util.List;
import me.shedaniel.clothconfig2.forge.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.forge.api.ConfigBuilder;
import me.shedaniel.clothconfig2.forge.api.ConfigCategory;
import me.shedaniel.clothconfig2.forge.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.forge.api.Modifier;
import me.shedaniel.clothconfig2.forge.api.ModifierKeyCode;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.teamfruit.savetools.InputHandler;

public class Config {
    public static final Config INSTANCE = new Config();
    public final ForgeConfigSpec config;
    public final General general;
    public final Material material;
    public final Advanced advanced;

    private Config() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        this.general = new General(builder);
        this.advanced = new Advanced(builder);
        this.material = new Material(builder);
        this.config = builder.build();
    }

    public Screen buildClothConfig(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((ITextComponent)new TranslationTextComponent("config.savetools.title"));
        ConfigEntryBuilder entry = builder.entryBuilder();
        ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.savetools.category.general"));
        general.addEntry((AbstractConfigListEntry)entry.startModifierKeyCodeField((ITextComponent)new TranslationTextComponent("key.savetools.toggle"), ModifierKeyCode.of((InputMappings.Input)InputHandler.KEY_TOGGLE.getKey(), (Modifier)Config.toClothModifier(InputHandler.KEY_TOGGLE.getKeyModifier()))).setDefaultValue(InputHandler.KEY_TOGGLE.func_197977_i()).setSaveConsumer(arg_0 -> ((KeyBinding)InputHandler.KEY_TOGGLE).func_197979_b(arg_0)).setModifierSaveConsumer(mod -> InputHandler.KEY_TOGGLE.setKeyModifierAndCode(Config.toForgeModifier(mod.getModifier()), mod.getKeyCode())).build());
        general.addEntry((AbstractConfigListEntry)entry.startModifierKeyCodeField((ITextComponent)new TranslationTextComponent("key.savetools.config"), ModifierKeyCode.of((InputMappings.Input)InputHandler.KEY_CONFIG.getKey(), (Modifier)Config.toClothModifier(InputHandler.KEY_CONFIG.getKeyModifier()))).setDefaultValue(InputHandler.KEY_CONFIG.func_197977_i()).setSaveConsumer(arg_0 -> ((KeyBinding)InputHandler.KEY_CONFIG).func_197979_b(arg_0)).setModifierSaveConsumer(mod -> InputHandler.KEY_CONFIG.setKeyModifierAndCode(Config.toForgeModifier(mod.getModifier()), mod.getKeyCode())).build());
        general.addEntry((AbstractConfigListEntry)entry.startIntSlider((ITextComponent)new TranslationTextComponent("config.savetools.interval.title"), ((Integer)this.general.interval.get()).intValue(), 0, 20).setDefaultValue(0).setTextGetter(i -> new StringTextComponent(i + " tick")).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.IntValue)this.general.interval).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.attack.title"), ((Boolean)this.general.attack.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.general.attack).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.use.title"), ((Boolean)this.general.use.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.general.use).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.onlyenchanted.title"), ((Boolean)this.general.onlyEnchanted.get()).booleanValue()).setDefaultValue(false).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.general.onlyEnchanted).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.useabsolute.title"), ((Boolean)this.general.useAbsolute.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.general.useAbsolute).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startIntField((ITextComponent)new TranslationTextComponent("config.savetools.absolutethreshold.title"), ((Integer)this.general.absoluteThreshold.get()).intValue()).setDefaultValue(2).setSaveConsumer(arg_0 -> this.general.absoluteThreshold.set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.usepercentage.title"), ((Boolean)this.general.usePercentage.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.general.usePercentage).set(arg_0)).build());
        general.addEntry((AbstractConfigListEntry)entry.startIntSlider((ITextComponent)new TranslationTextComponent("config.savetools.percentagethreshold.title"), ((Integer)this.general.percentageThreshold.get()).intValue(), 0, 100).setDefaultValue(1).setTextGetter(i -> new StringTextComponent(i + " %")).setSaveConsumer(arg_0 -> this.general.percentageThreshold.set(arg_0)).build());
        ConfigCategory material = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.savetools.category.material"));
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.wood"), ((Boolean)this.material.wood.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.wood).set(arg_0)).build());
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.stone"), ((Boolean)this.material.stone.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.stone).set(arg_0)).build());
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.iron"), ((Boolean)this.material.iron.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.iron).set(arg_0)).build());
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.gold"), ((Boolean)this.material.gold.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.gold).set(arg_0)).build());
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.diamond"), ((Boolean)this.material.diamond.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.diamond).set(arg_0)).build());
        material.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.netherite"), ((Boolean)this.material.netherite.get()).booleanValue()).setDefaultValue(true).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.material.netherite).set(arg_0)).build());
        ConfigCategory advanced = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("config.savetools.category.advanced"));
        advanced.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.enablelistfilter.title"), ((Boolean)this.advanced.enableListFiler.get()).booleanValue()).setDefaultValue(false).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.advanced.enableListFiler).set(arg_0)).build());
        advanced.addEntry((AbstractConfigListEntry)entry.startTextDescription((ITextComponent)new TranslationTextComponent("config.savetools.advanced.description1")).build());
        advanced.addEntry((AbstractConfigListEntry)entry.startTextDescription((ITextComponent)new TranslationTextComponent("config.savetools.advanced.description2")).build());
        advanced.addEntry((AbstractConfigListEntry)entry.startBooleanToggle((ITextComponent)new TranslationTextComponent("config.savetools.whitelistmode.title"), ((Boolean)this.advanced.whitelistMode.get()).booleanValue()).setDefaultValue(false).setSaveConsumer(arg_0 -> ((ForgeConfigSpec.BooleanValue)this.advanced.whitelistMode).set(arg_0)).build());
        advanced.addEntry((AbstractConfigListEntry)entry.startStrList((ITextComponent)new TranslationTextComponent("config.savetools.blacklist.title"), (List)this.advanced.list.get()).setDefaultValue(Advanced.DEFAULT_LIST).setSaveConsumer(arg_0 -> this.advanced.list.set(arg_0)).build());
        return builder.setSavingRunnable(() -> ((ForgeConfigSpec)this.config).save()).build();
    }

    public static Modifier toClothModifier(KeyModifier modifier) {
        return Modifier.of((modifier == KeyModifier.ALT ? 1 : 0) != 0, (modifier == KeyModifier.CONTROL ? 1 : 0) != 0, (modifier == KeyModifier.SHIFT ? 1 : 0) != 0);
    }

    public static KeyModifier toForgeModifier(Modifier modifier) {
        if (modifier.hasAlt()) {
            return KeyModifier.ALT;
        }
        if (modifier.hasControl()) {
            return KeyModifier.CONTROL;
        }
        if (modifier.hasShift()) {
            return KeyModifier.SHIFT;
        }
        return KeyModifier.NONE;
    }

    public static class Advanced {
        public static final List<String> DEFAULT_LIST = Arrays.asList("minecraft:wooden_sword", "minecraft:wooden_shovel", "minecraft:wooden_pickaxe", "minecraft:wooden_axe", "minecraft:wooden_hoe", "minecraft:stone_sword", "minecraft:stone_shovel", "minecraft:stone_pickaxe", "minecraft:stone_axe", "minecraft:stone_hoe");
        public final ForgeConfigSpec.BooleanValue enableListFiler;
        public final ForgeConfigSpec.BooleanValue whitelistMode;
        public final ForgeConfigSpec.ConfigValue<List<String>> list;

        public Advanced(ForgeConfigSpec.Builder builder) {
            builder.push("Advanced");
            this.enableListFiler = builder.comment("Enable list filter").define("enablelistfiler", false);
            this.whitelistMode = builder.comment("Whitelist mode").define("whitelistmode", false);
            this.list = builder.comment("Item blacklist").define("blacklist", DEFAULT_LIST);
            builder.pop();
        }
    }

    public static class Material {
        public final ForgeConfigSpec.BooleanValue wood;
        public final ForgeConfigSpec.BooleanValue stone;
        public final ForgeConfigSpec.BooleanValue iron;
        public final ForgeConfigSpec.BooleanValue gold;
        public final ForgeConfigSpec.BooleanValue diamond;
        public final ForgeConfigSpec.BooleanValue netherite;

        public Material(ForgeConfigSpec.Builder builder) {
            builder.push("Material");
            this.wood = builder.comment("Wooden tools").define("wood", true);
            this.stone = builder.comment("Stone tools").define("stone", true);
            this.iron = builder.comment("Iron tools").define("iron", true);
            this.gold = builder.comment("Golden tools").define("gold", true);
            this.diamond = builder.comment("Diamond tools").define("diamond", true);
            this.netherite = builder.comment("Netherite tools").define("netherite", true);
            builder.pop();
        }
    }

    public static class General {
        public final ForgeConfigSpec.IntValue interval;
        public final ForgeConfigSpec.BooleanValue attack;
        public final ForgeConfigSpec.BooleanValue use;
        public final ForgeConfigSpec.BooleanValue onlyEnchanted;
        public final ForgeConfigSpec.BooleanValue useAbsolute;
        public final ForgeConfigSpec.ConfigValue<Integer> absoluteThreshold;
        public final ForgeConfigSpec.BooleanValue usePercentage;
        public final ForgeConfigSpec.ConfigValue<Integer> percentageThreshold;

        public General(ForgeConfigSpec.Builder builder) {
            builder.push("General");
            this.interval = builder.comment(new String[]{"Tick interval to monitor the durability of the tool", "Increasing the value reduces the load, but may not work as well when using tool at high speeds"}).defineInRange("interval", 0, 0, 20);
            this.attack = builder.comment("Whether it works in an attack action").define("attack", true);
            this.use = builder.comment("Whether it works in an attack action").define("use", true);
            this.onlyEnchanted = builder.comment("Save only the enchanted tools").define("onlyenchanted", false);
            this.useAbsolute = builder.comment("Use absolute value threshold").define("useabsolute", true);
            this.absoluteThreshold = builder.comment("Absolute threshold").define("absolutethreshold", (Object)2);
            this.usePercentage = builder.comment("Use percentage value threshold").define("usepercentage", true);
            this.percentageThreshold = builder.comment("Percentage threshold").define("percentagethreshold", (Object)1);
            builder.pop();
        }
    }
}

