/*
 * Decompiled with CFR 0.152.
 */
package net.teamfruit.savetools;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.teamfruit.savetools.ChatUtil;
import net.teamfruit.savetools.Config;
import net.teamfruit.savetools.InputHandler;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    private int tickCount = 0;

    private TickHandler() {
    }

    private boolean tickInterval() {
        int interval = (Integer)Config.INSTANCE.general.interval.get();
        if (interval <= 0) {
            return true;
        }
        if (this.tickCount == interval) {
            this.tickCount = 0;
            return true;
        }
        ++this.tickCount;
        return false;
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        RayTraceResult rayTrace;
        boolean save;
        boolean use;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        InputHandler.INSTANCE.onTick();
        if (!InputHandler.INSTANCE.isEnabled()) {
            return;
        }
        if (!this.tickInterval()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null || player.func_184812_l_()) {
            return;
        }
        boolean attack = mc.field_71474_y.field_74312_F.func_151470_d() && (Boolean)Config.INSTANCE.general.attack.get() != false;
        boolean bl = use = mc.field_71474_y.field_74313_G.func_151470_d() && (Boolean)Config.INSTANCE.general.use.get() != false;
        if (!attack && !use) {
            return;
        }
        ItemStack item = player.func_184614_ca();
        if (!item.func_77984_f()) {
            return;
        }
        if (((Boolean)Config.INSTANCE.general.onlyEnchanted.get()).booleanValue() && !item.func_77948_v()) {
            return;
        }
        int remaiming = item.func_77958_k() - item.func_77952_i();
        boolean bl2 = save = (Boolean)Config.INSTANCE.general.usePercentage.get() != false && (float)remaiming <= (float)item.func_77958_k() * ((float)((Integer)Config.INSTANCE.general.percentageThreshold.get()).intValue() / 100.0f) || (Boolean)Config.INSTANCE.general.useAbsolute.get() != false && remaiming <= (Integer)Config.INSTANCE.general.absoluteThreshold.get();
        if (!save) {
            return;
        }
        String name = Optional.ofNullable(item.func_77973_b().getRegistryName()).map(ResourceLocation::toString).orElseGet(() -> item.func_77973_b().toString());
        if (((Boolean)Config.INSTANCE.advanced.enableListFiler.get()).booleanValue()) {
            if (((Boolean)Config.INSTANCE.advanced.whitelistMode.get()).booleanValue()) {
                if (((List)Config.INSTANCE.advanced.list.get()).stream().noneMatch(name::equals)) {
                    return;
                }
            } else if (((List)Config.INSTANCE.advanced.list.get()).stream().anyMatch(name::equals)) {
                return;
            }
        }
        if (!((Boolean)Config.INSTANCE.material.wood.get()).booleanValue() && name.startsWith("minecraft:wooden_")) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.material.stone.get()).booleanValue() && name.startsWith("minecraft:stone_")) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.material.iron.get()).booleanValue() && name.startsWith("minecraft:iron_")) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.material.gold.get()).booleanValue() && name.startsWith("minecraft:golden_")) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.material.diamond.get()).booleanValue() && name.startsWith("minecraft:diamond_")) {
            return;
        }
        if (!((Boolean)Config.INSTANCE.material.netherite.get()).booleanValue() && name.startsWith("minecraft:netherite_")) {
            return;
        }
        if (attack && (rayTrace = mc.field_71476_x) != null && rayTrace.func_216346_c() != RayTraceResult.Type.MISS) {
            if (rayTrace instanceof BlockRayTraceResult) {
                BlockPos pos;
                ClientWorld world = mc.field_71441_e;
                if (world != null && world.func_180495_p(pos = ((BlockRayTraceResult)rayTrace).func_216350_a()).func_185887_b((IBlockReader)world, pos) != 0.0f) {
                    this.saveTool();
                }
            } else {
                this.saveTool();
            }
        }
        if (use) {
            this.saveTool();
        }
    }

    public void saveTool() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        Container con = this.getInventoryContainer(player);
        int toolSlotId = player.field_71071_by.field_70461_c;
        int serverToolSlotId = this.toServerSlotId(toolSlotId);
        int i = 0;
        int swapSlot = -1;
        for (Slot slot : con.field_75151_b) {
            if (++i <= 9) continue;
            if (swapSlot < 0 && !slot.func_75211_c().func_77984_f()) {
                swapSlot = slot.getSlotIndex();
            }
            if (slot.func_75216_d()) continue;
            this.click(con, serverToolSlotId);
            this.click(con, this.toServerSlotId(slot.getSlotIndex()));
            this.sendSaveMessage();
            return;
        }
        if (swapSlot < 0) {
            swapSlot = 35;
        }
        this.click(con, serverToolSlotId);
        this.click(con, this.toServerSlotId(swapSlot));
        this.click(con, serverToolSlotId);
        this.sendSaveMessage();
    }

    private Container getInventoryContainer(ClientPlayerEntity player) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r != null && mc.field_71462_r instanceof ContainerScreen) {
            return ((ContainerScreen)mc.field_71462_r).func_212873_a_();
        }
        return player.field_71069_bz;
    }

    private void click(Container container, int slotId) {
        PlayerController playerController = Minecraft.func_71410_x().field_71442_b;
        if (playerController != null) {
            playerController.func_187098_a(container.field_75152_c, slotId, 0, ClickType.PICKUP, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        }
    }

    private int toServerSlotId(int clientSlotId) {
        if (clientSlotId <= 8) {
            return clientSlotId + 36;
        }
        if (clientSlotId == 40) {
            return 45;
        }
        return clientSlotId;
    }

    private void sendSaveMessage() {
        ChatUtil.saveToolsMessage((ITextComponent)new TranslationTextComponent("message.savetools.saved").func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.YELLOW)));
    }
}

