/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc;

import enginecrafter77.survivalinc.ModBlocks;
import enginecrafter77.survivalinc.block.BlockMelting;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.ghost.GhostCommand;
import enginecrafter77.survivalinc.ghost.GhostProvider;
import enginecrafter77.survivalinc.net.EntityItemUpdateMessage;
import enginecrafter77.survivalinc.net.EntityItemUpdater;
import enginecrafter77.survivalinc.net.StatSyncHandler;
import enginecrafter77.survivalinc.net.StatSyncMessage;
import enginecrafter77.survivalinc.net.WaterDrinkMessage;
import enginecrafter77.survivalinc.season.SeasonCommand;
import enginecrafter77.survivalinc.season.SeasonController;
import enginecrafter77.survivalinc.season.SeasonSyncMessage;
import enginecrafter77.survivalinc.season.melting.MeltingController;
import enginecrafter77.survivalinc.stats.StatCommand;
import enginecrafter77.survivalinc.stats.StatRegisterDispatcher;
import enginecrafter77.survivalinc.stats.StatStorage;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.impl.HeatModifier;
import enginecrafter77.survivalinc.stats.impl.HydrationModifier;
import enginecrafter77.survivalinc.stats.impl.SanityModifier;
import enginecrafter77.survivalinc.stats.impl.WetnessModifier;
import java.util.concurrent.Callable;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    public SimpleNetworkWrapper net;

    public void preInit(FMLPreInitializationEvent event) {
        if (ModConfig.SEASONS.enabled) {
            MinecraftForge.EVENT_BUS.register((Object)SeasonController.instance);
            MeltingController.meltmap.add(new MeltingController.MelterEntry((BlockMelting)ModBlocks.MELTING_SNOW.get()).level(1, true));
            MeltingController.meltmap.add(new MeltingController.MelterEntry((BlockMelting)ModBlocks.MELTING_ICE.get()).level(0, true));
        }
        CapabilityManager.INSTANCE.register(StatTracker.class, StatStorage.instance, (Callable)StatRegisterDispatcher.instance);
    }

    public void init(FMLInitializationEvent event) {
        this.net = NetworkRegistry.INSTANCE.newSimpleChannel("survivalinc");
        this.net.registerMessage(StatSyncHandler.class, StatSyncMessage.class, 0, Side.CLIENT);
        this.net.registerMessage((IMessageHandler)SeasonController.instance, SeasonSyncMessage.class, 1, Side.CLIENT);
        this.net.registerMessage(EntityItemUpdater.class, EntityItemUpdateMessage.class, 2, Side.CLIENT);
        this.net.registerMessage(HydrationModifier.class, WaterDrinkMessage.class, 3, Side.SERVER);
        if (ModConfig.HEAT.enabled) {
            HeatModifier.instance.init();
        }
        if (ModConfig.HYDRATION.enabled) {
            HydrationModifier.instance.init();
        }
        if (ModConfig.SANITY.enabled) {
            SanityModifier.instance.init();
        }
        if (ModConfig.WETNESS.enabled) {
            WetnessModifier.instance.init();
        }
        if (ModConfig.GHOST.enabled) {
            GhostProvider.instance.init();
        }
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (ModConfig.SEASONS.enabled && ModConfig.SEASONS.meltController.isValid()) {
            MeltingController.compile(ModConfig.SEASONS.meltController);
            MinecraftForge.EVENT_BUS.register(MeltingController.class);
        }
    }

    public void serverStarting(FMLServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        CommandHandler manager = (CommandHandler)server.func_71187_D();
        if (ModConfig.SEASONS.enabled) {
            manager.func_71560_a((ICommand)new SeasonCommand());
        }
        if (ModConfig.GHOST.enabled) {
            manager.func_71560_a((ICommand)new GhostCommand());
        }
        manager.func_71560_a((ICommand)new StatCommand());
    }
}

