/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc;

import enginecrafter77.survivalinc.block.BlockMeltingIce;
import enginecrafter77.survivalinc.block.BlockMeltingSnow;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum ModBlocks implements Supplier<Block>
{
    MELTING_SNOW(new BlockMeltingSnow()),
    MELTING_ICE(new BlockMeltingIce());

    private final Block instance;

    private ModBlocks(Block instance) {
        this.instance = instance;
    }

    @Override
    public Block get() {
        return this.instance;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry reg = event.getRegistry();
        for (ModBlocks block : ModBlocks.values()) {
            reg.register((IForgeRegistryEntry)block.instance);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        for (ModBlocks block : ModBlocks.values()) {
            ItemBlock blockitem = new ItemBlock(block.instance);
            blockitem.setRegistryName(block.instance.getRegistryName());
            reg.register((IForgeRegistryEntry)blockitem);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (ModBlocks block : ModBlocks.values()) {
            Item blockitem = Item.func_150898_a((Block)block.instance);
            ModelLoader.setCustomModelResourceLocation((Item)blockitem, (int)0, (ModelResourceLocation)new ModelResourceLocation(blockitem.getRegistryName(), "inventory"));
        }
    }
}

