/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.item.ItemCanteen;
import enginecrafter77.survivalinc.item.ItemFeatherFan;
import enginecrafter77.survivalinc.item.ItemTowel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public enum ModItems {
    CANTEEN((Item)new ItemCanteen(), "canteen_drain", "canteen_refill"),
    FEATHER_FAN((Item)new ItemFeatherFan(), "feather_fan"),
    TOWEL((Item)new ItemTowel(), "towel_dry", "towel_wet");

    public final Item target;
    public final String[] models;
    public final int[] mappings;

    private ModItems(Item instance, int[] mappings, String ... models) {
        this.target = instance;
        this.models = models;
        this.mappings = mappings;
    }

    private ModItems(Item instance, String ... models) {
        this(instance, new int[0], models);
    }

    public Item getItem() {
        return this.target;
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        for (ModItems mi : ModItems.values()) {
            reg.register((IForgeRegistryEntry)mi.getItem());
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (ModItems entry : ModItems.values()) {
            Item item = entry.getItem();
            int index = 0;
            for (String model : entry.models) {
                int meta = index;
                if (entry.mappings.length > index) {
                    meta = entry.mappings[index];
                }
                ResourceLocation loc = new ResourceLocation("survivalinc", model);
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(loc, "inventory"));
                SurvivalInc.logger.info("Registering model {} on meta {} for item {}", (Object)loc.toString(), (Object)meta, (Object)item.getRegistryName().toString());
                ++index;
            }
        }
    }
}

