/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.block;

import enginecrafter77.survivalinc.config.ModConfig;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockMelting
extends Block {
    public final Block meltTarget;
    public final Block freezeTarget;
    private PropertyInteger phase_property;
    public float freezing_point = 0.15f;

    public BlockMelting(Block frozen, Block melted) {
        super(frozen.func_176223_P().func_185904_a());
        this.freezeTarget = frozen;
        this.meltTarget = melted;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.phase_property, (Comparable)Integer.valueOf(0)));
    }

    protected BlockStateContainer func_180661_e() {
        this.phase_property = PropertyInteger.func_177719_a((String)"meltphase", (int)0, (int)this.getPhaseCount());
        return new BlockStateContainer((Block)this, new IProperty[]{this.phase_property});
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.phase_property);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.phase_property, (Comparable)Integer.valueOf(meta));
    }

    public boolean func_149653_t() {
        return ModConfig.SEASONS.meltController.requiresRandomTicks();
    }

    public void func_180650_b(World world, BlockPos position, IBlockState state, Random rng) {
        world.field_72984_F.func_76320_a("melting");
        MeltAction action = this.getAction(world, position);
        if (action != MeltAction.PASS) {
            int phase = (Integer)state.func_177229_b((IProperty)this.phase_property) + action.getPhaseIncrement();
            if (this.phase_property.func_177700_c().contains(phase)) {
                state = state.func_177226_a((IProperty)this.phase_property, (Comparable)Integer.valueOf(phase));
                world.func_180501_a(position, state, 2);
            } else {
                IBlockState next = this.transform(world, position, action);
                if (next != null) {
                    world.func_180501_a(position, next, 2);
                }
            }
        }
        world.field_72984_F.func_76319_b();
    }

    public int getPhaseCount() {
        return 3;
    }

    public IBlockState transform(World world, BlockPos position, MeltAction action) {
        switch (action) {
            case FREEZE: {
                return this.freezeTarget.func_176223_P();
            }
            case MELT: {
                return this.meltTarget.func_176223_P();
            }
        }
        return null;
    }

    public MeltAction getAction(World world, BlockPos position) {
        return world.func_180494_b(position).func_180626_a(position) > this.freezing_point ? MeltAction.MELT : MeltAction.FREEZE;
    }

    public static enum MeltAction {
        FREEZE,
        PASS,
        MELT;


        public int getPhaseIncrement() {
            return this.ordinal() - 1;
        }
    }
}

