/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.SimpleOverlayElement;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatTracker;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DifferentialArrow
extends SimpleOverlayElement<StatTracker> {
    public static final ResourceLocation arrowtexture = new ResourceLocation("survivalinc", "textures/gui/arrow.png");
    public final StatProvider<? extends SimpleStatRecord> provider;
    public final boolean logarithmic;
    protected float amplitude;
    protected float min_scale;
    protected float max_scale;

    public DifferentialArrow(StatProvider<? extends SimpleStatRecord> provider, int width, int height, boolean logarithmic) {
        super(width, height);
        this.logarithmic = logarithmic;
        this.provider = provider;
        this.amplitude = 10.0f;
        this.min_scale = 0.3f;
        this.max_scale = 1.0f;
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, StatTracker tracker) {
        this.texturer.func_110577_a(arrowtexture);
        float value = this.getArrowScale(tracker);
        boolean inverse = value < 0.0f;
        value = Math.abs(value);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(position.getX(resolution) + this.width / 2), (float)(position.getY(resolution) + this.height / 2), (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)value, (float)value, (float)1.0f);
        if (inverse) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        Gui.func_146110_a((int)(-this.width / 2), (int)(-this.height / 2), (float)0.0f, (float)0.0f, (int)this.width, (int)this.height, (float)8.0f, (float)12.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
    }

    public float getArrowScale(StatTracker tracker) {
        SimpleStatRecord record = tracker.getRecord(this.provider);
        float scale = Math.abs(record.getLastChange() * this.amplitude);
        if (this.logarithmic) {
            scale = (1.0f - (float)Math.pow(6.0, -2.0f * scale)) / (1.0f - (float)Math.pow(6.0, -2.0));
        }
        if (scale > this.max_scale) {
            scale = this.max_scale;
        }
        if (scale < this.min_scale && scale != 0.0f) {
            scale = this.min_scale;
        }
        if (record.getLastChange() < 0.0f) {
            scale *= -1.0f;
        }
        return scale;
    }
}

