/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.SimpleOverlayElement;
import enginecrafter77.survivalinc.config.ModConfig;
import java.awt.Color;
import java.awt.color.ColorSpace;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GaugeBar
extends SimpleOverlayElement<Float> {
    private static final ResourceLocation bartemplate = new ResourceLocation("survivalinc", "textures/gui/statusbar.png");
    private static final int bartemplate_width = 16;
    private static final int bartemplate_height = 32;
    public final Color color;
    private boolean recalculateColor = true;
    private float[] colorcomponents = new float[4];

    public GaugeBar(Color color) {
        super(8, 32);
        this.color = color;
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, Float prop) {
        float propheight = (float)this.getHeight() * prop.floatValue();
        int bar_bottom_dist = Math.round(propheight);
        int bar_top_dist = Math.round((float)this.getHeight() - propheight);
        if (this.recalculateColor) {
            this.calculateRGBColor(prop.floatValue());
            this.recalculateColor = false;
        }
        GlStateManager.func_179141_d();
        this.texturer.func_110577_a(bartemplate);
        int x = position.getX(resolution);
        int y = position.getY(resolution);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)this.getWidth(), (int)this.getHeight(), (float)16.0f, (float)32.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)this.colorcomponents[0], (float)this.colorcomponents[1], (float)this.colorcomponents[2], (float)this.colorcomponents[3]);
        Gui.func_146110_a((int)x, (int)(y + bar_top_dist), (float)this.getWidth(), (float)bar_top_dist, (int)this.getWidth(), (int)bar_bottom_dist, (float)16.0f, (float)32.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179118_c();
    }

    public void recalculateColor() {
        this.recalculateColor = true;
    }

    protected void calculateRGBColor(float fraction) {
        this.getColor(fraction).getColorComponents(ColorSpace.getInstance(1000), this.colorcomponents);
        this.colorcomponents[3] = 1.0f - (float)ModConfig.CLIENT.barTransparency;
    }

    public Color getColor(float proportion) {
        return this.color;
    }
}

