/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.ElementRenderFilter;
import enginecrafter77.survivalinc.client.OverlayElement;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatTracker;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderHUD {
    public static final RenderHUD instance = new RenderHUD(RenderGameOverlayEvent.ElementType.ALL);
    protected final Map<OverlayElement<? super StatTracker>, ElementPositioner> elements = new LinkedHashMap<OverlayElement<? super StatTracker>, ElementPositioner>();
    protected final Map<RenderGameOverlayEvent.ElementType, Collection<ElementRenderFilter<? super StatTracker>>> filters = new HashMap<RenderGameOverlayEvent.ElementType, Collection<ElementRenderFilter<? super StatTracker>>>();
    protected final RenderGameOverlayEvent.ElementType trigger;

    public RenderHUD(RenderGameOverlayEvent.ElementType trigger) {
        this.trigger = trigger;
    }

    public void addIndependent(OverlayElement<? super StatTracker> element, ElementPositioner position) {
        this.elements.put(element, position);
    }

    public void addFilter(ElementRenderFilter<? super StatTracker> filter, RenderGameOverlayEvent.ElementType element) {
        Collection<ElementRenderFilter<? super StatTracker>> filters = this.filters.get(element);
        if (filters == null) {
            filters = new LinkedList<ElementRenderFilter<? super StatTracker>>();
            this.filters.put(element, filters);
        }
        filters.add(filter);
    }

    public void addFilterToAll(ElementRenderFilter<? super StatTracker> filter, RenderGameOverlayEvent.ElementType ... elements) {
        for (RenderGameOverlayEvent.ElementType element : elements) {
            this.addFilter(filter, element);
        }
    }

    public boolean isUseful() {
        return !this.elements.isEmpty() && !this.filters.isEmpty();
    }

    private void runEndFilters(ScaledResolution resolution, RenderGameOverlayEvent.ElementType element, StatTracker tracker) {
        Collection<ElementRenderFilter<? super StatTracker>> filters = this.filters.get(element);
        if (filters != null) {
            for (ElementRenderFilter<? super StatTracker> filter : filters) {
                filter.end(resolution, tracker);
            }
        }
    }

    @SubscribeEvent
    public void renderOverlayPre(RenderGameOverlayEvent.Pre event) {
        StatTracker tracker = (StatTracker)Minecraft.func_71410_x().field_71439_g.getCapability(StatCapability.target, null);
        Collection<ElementRenderFilter<? super StatTracker>> filters = this.filters.get(event.getType());
        if (filters != null) {
            for (ElementRenderFilter<? super StatTracker> filter : filters) {
                boolean render = filter.begin(event.getResolution(), tracker);
                if (render) continue;
                event.setCanceled(true);
            }
        }
        if (event.isCanceled()) {
            this.runEndFilters(event.getResolution(), event.getType(), tracker);
        }
    }

    @SubscribeEvent
    public void renderOverlayPost(RenderGameOverlayEvent.Post event) {
        StatTracker tracker = (StatTracker)Minecraft.func_71410_x().field_71439_g.getCapability(StatCapability.target, null);
        RenderGameOverlayEvent.ElementType type = event.getType();
        if (this.trigger == type) {
            for (Map.Entry<OverlayElement<? super StatTracker>, ElementPositioner> entry : this.elements.entrySet()) {
                entry.getKey().draw(event.getResolution(), entry.getValue(), event.getPartialTicks(), tracker);
            }
        }
        this.runEndFilters(event.getResolution(), type, tracker);
    }
}

