/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.Axis2D;
import enginecrafter77.survivalinc.client.Direction2D;
import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.OverlayElement;
import enginecrafter77.survivalinc.client.SymbolFillBar;
import enginecrafter77.survivalinc.client.TexturedElement;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class StatFillBar<RECORD extends StatRecord>
implements OverlayElement<StatTracker> {
    public final SymbolFillBar background;
    public final StatProvider<RECORD> provider;
    protected final Map<SymbolFillBar, Function<RECORD, Float>> layers = new LinkedHashMap<SymbolFillBar, Function<RECORD, Float>>();

    public StatFillBar(StatProvider<RECORD> provider, Direction2D direction, TexturedElement base) {
        this.background = new SymbolFillBar(base, direction);
        this.provider = provider;
    }

    @Deprecated
    public StatFillBar(StatProvider<RECORD> provider, Class<RECORD> recordclass, Direction2D direction, TexturedElement base) {
        this(provider, direction, base);
    }

    public void setSpacing(int spacing) {
        this.background.setSpacing(spacing);
        for (SymbolFillBar bar : this.layers.keySet()) {
            bar.setSpacing(spacing);
        }
    }

    public void setCapacity(int capacity) {
        this.background.setCapacity(capacity);
        for (SymbolFillBar bar : this.layers.keySet()) {
            bar.setCapacity(capacity);
        }
    }

    public void addLayer(TexturedElement texture, Function<RECORD, Float> getter) {
        SymbolFillBar bar = new SymbolFillBar(texture, this.background.direction);
        bar.setCapacity(this.background.getCapacity());
        bar.setSpacing(this.background.getSpacing());
        this.layers.put(bar, getter);
    }

    @Override
    public int getSize(Axis2D axis) {
        return this.background.getSize(axis);
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, StatTracker arg) {
        if (arg.isActive(this.provider, (EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
            this.background.draw(resolution, position, partialTicks, Float.valueOf(1.0f));
            RECORD record = arg.getRecord(this.provider);
            for (Map.Entry<SymbolFillBar, Function<RECORD, Float>> entry : this.layers.entrySet()) {
                Function<RECORD, Float> transformer = entry.getValue();
                Float value = transformer.apply(record);
                if (value == null) continue;
                entry.getKey().draw(resolution, position, partialTicks, value);
            }
        }
    }
}

