/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.Axis2D;
import enginecrafter77.survivalinc.client.Direction2D;
import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.OverlayElement;
import enginecrafter77.survivalinc.client.TexturedElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SymbolFillBar
implements OverlayElement<Float> {
    public final TexturedElement symbol;
    public final Direction2D direction;
    protected int capacity;
    protected int spacing;

    public SymbolFillBar(TexturedElement symbol, Direction2D direction) {
        this.direction = direction;
        this.symbol = symbol;
        this.capacity = 1;
        this.spacing = 0;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public void setCapacity(int count) {
        this.capacity = count;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public int getSpacing() {
        return this.spacing;
    }

    protected int calculateOffsetOn(float fill, int index, Axis2D axis) {
        int offset = 0;
        int size = this.symbol.getSize(axis);
        if (this.direction.axis == axis) {
            if (!this.direction.isNormal()) {
                offset = this.getSize(axis) - (size + this.spacing) + Math.round((1.0f - fill) * (float)size);
            }
            offset += index * (size + this.spacing) * this.direction.getAxialDelta();
        }
        return offset;
    }

    protected int calculateDimensionOn(float fill, Axis2D axis) {
        int dimension = this.symbol.getSize(axis);
        if (this.direction.axis == axis) {
            dimension = Math.round((float)dimension * fill);
        }
        return dimension;
    }

    protected void drawSymbol(TexturedElement.TextureDrawingContext context, int index, int x, int y, float fill) {
        int width = this.calculateDimensionOn(fill, Axis2D.HORIZONTAL);
        int height = this.calculateDimensionOn(fill, Axis2D.VERTICAL);
        int offx = 0;
        int offy = 0;
        if (!this.direction.isNormal()) {
            offx = context.width - width;
            offy = context.height - height;
        }
        context.drawPartial(x += this.calculateOffsetOn(fill, index, Axis2D.HORIZONTAL), y += this.calculateOffsetOn(fill, index, Axis2D.VERTICAL), offx, offy, width, height);
    }

    @Override
    public int getSize(Axis2D axis) {
        int dimension = this.symbol.getSize(axis);
        if (this.direction.axis == axis) {
            dimension = this.capacity * (dimension + this.spacing);
        }
        return dimension;
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, Float length) {
        length = Float.valueOf(length.floatValue() * (float)this.capacity);
        int x = position.getX(resolution);
        int y = position.getY(resolution);
        int steps = (int)Math.round(Math.floor(length.floatValue()));
        TexturedElement.TextureDrawingContext context = this.symbol.createContext(Minecraft.func_71410_x().func_110434_K());
        for (int piece = 0; piece <= steps; ++piece) {
            this.drawSymbol(context, piece, x, y, Math.min(1.0f, length.floatValue() - (float)piece));
        }
        context.close();
    }
}

