/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.client;

import enginecrafter77.survivalinc.client.Axis2D;
import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.OverlayElement;
import enginecrafter77.survivalinc.client.SimpleOverlayElement;
import enginecrafter77.survivalinc.client.TextureResource;
import java.io.Closeable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TexturedElement
extends SimpleOverlayElement<Object> {
    public final TextureResource resource;
    public final int offset_x;
    public final int offset_y;
    public final boolean hasAlpha;
    private static TextureDrawingContext current_context = null;

    public TexturedElement(TextureResource resource, int offset_x, int offset_y, int width, int height, boolean alpha) {
        super(width, height);
        this.resource = resource;
        this.offset_x = offset_x;
        this.offset_y = offset_y;
        this.hasAlpha = alpha;
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, Object arg) {
        TextureDrawingContext context = this.createContext(this.texturer);
        context.draw(resolution, position, partialTicks, arg);
        context.close();
    }

    public TextureDrawingContext createContext(TextureManager manager) throws IllegalStateException {
        if (current_context != null) {
            throw new IllegalStateException("Attempting to create a nested context!");
        }
        current_context = new TextureDrawingContext(manager, this.width, this.height);
        current_context.enable(manager);
        return current_context;
    }

    public class TextureDrawingContext
    implements OverlayElement<Object>,
    Closeable {
        public final TextureManager manager;
        protected final int width;
        protected final int height;

        public TextureDrawingContext(TextureManager manager, int width, int height) {
            this.manager = manager;
            this.height = height;
            this.width = width;
        }

        protected void enable(TextureManager manager) {
            if (TexturedElement.this.hasAlpha) {
                GlStateManager.func_179141_d();
            }
            TexturedElement.this.resource.load(manager);
        }

        protected void disable() {
            if (TexturedElement.this.hasAlpha) {
                GlStateManager.func_179118_c();
            }
        }

        public void drawPartial(int x, int y, int offx, int offy, int width, int height) {
            Gui.func_146110_a((int)x, (int)y, (float)(TexturedElement.this.offset_x + offx), (float)(TexturedElement.this.offset_y + offy), (int)width, (int)height, (float)TexturedElement.this.resource.texture_width, (float)TexturedElement.this.resource.texture_height);
        }

        public void draw(int x, int y) {
            this.drawPartial(x, y, 0, 0, this.width, this.height);
        }

        @Override
        public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, Object arg) {
            this.draw(position.getX(resolution), position.getY(resolution));
        }

        @Override
        public int getSize(Axis2D axis) {
            switch (axis) {
                case HORIZONTAL: {
                    return this.width;
                }
                case VERTICAL: {
                    return this.height;
                }
            }
            throw new UnsupportedOperationException("Axis " + axis.name() + " doesn't exist!");
        }

        @Override
        public void close() {
            this.disable();
            if (current_context != this) {
                throw new IllegalStateException("Attepting to close from non-owning context!");
            }
            current_context = null;
        }
    }
}

