/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import com.google.common.collect.ImmutableSet;
import enginecrafter77.survivalinc.client.Direction2D;
import enginecrafter77.survivalinc.client.ElementPositioner;
import enginecrafter77.survivalinc.client.StatFillBar;
import enginecrafter77.survivalinc.client.TextureResource;
import enginecrafter77.survivalinc.client.TexturedElement;
import enginecrafter77.survivalinc.ghost.GhostEnergyRecord;
import enginecrafter77.survivalinc.ghost.GhostProvider;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatTracker;
import java.util.Set;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GhostEnergyBar
extends StatFillBar<GhostEnergyRecord> {
    public static final TextureResource texture = new TextureResource(new ResourceLocation("survivalinc", "textures/gui/ghostenergy.png"), 9, 27);
    public static final Set<RenderGameOverlayEvent.ElementType> replaced = ImmutableSet.of((Object)RenderGameOverlayEvent.ElementType.FOOD, (Object)RenderGameOverlayEvent.ElementType.ARMOR, (Object)RenderGameOverlayEvent.ElementType.HEALTH);

    public GhostEnergyBar() {
        super(GhostProvider.instance, Direction2D.RIGHT, new TexturedElement(texture, 0, 0, 9, 9, true));
        this.addLayer(new TexturedElement(texture, 0, 9, 9, 9, true), SimpleStatRecord::getNormalizedValue);
        this.addLayer(new TexturedElement(texture, 0, 18, 9, 9, true), GhostEnergyBar::ressurectionValue);
        this.setCapacity(10);
        this.setSpacing(-1);
    }

    public static Float ressurectionValue(GhostEnergyRecord record) {
        return record.isResurrectionActive() ? Float.valueOf(record.getResurrectionProgress()) : null;
    }

    @Override
    public void draw(ScaledResolution resolution, ElementPositioner position, float partialTicks, StatTracker tracker) {
        if (((GhostEnergyRecord)tracker.getRecord(this.provider)).isActive()) {
            super.draw(resolution, position, partialTicks, tracker);
        }
    }
}

