/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import com.google.common.collect.Range;
import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import net.minecraft.nbt.NBTTagCompound;

public class GhostEnergyRecord
extends SimpleStatRecord {
    public static final String[] status_desc = new String[]{"INACTIVE", "ACTIVE", "DEACTIVATING", "ACTIVATING"};
    private byte status;
    private int resurrection_progress;

    public GhostEnergyRecord() {
        this.setValueRange((Range<Float>)Range.closed((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(100.0f)));
        this.status = 0;
        this.resurrection_progress = -1;
    }

    public boolean shouldReceiveTicks() {
        return this.status != 0;
    }

    public boolean isActive() {
        return (this.status & 1) > 0;
    }

    public void setActive(boolean active) {
        this.status = (byte)(this.status & 0xFE);
        if (active) {
            this.status = (byte)(this.status | 1);
        }
        this.status = (byte)(this.status | 2);
        SurvivalInc.logger.info("Setting ghost status {}.", (Object)this.getStatus());
    }

    public boolean hasPendingChange() {
        return (this.status & 2) > 0;
    }

    public void acceptChange() {
        this.status = (byte)(this.status & 0xFD);
        SurvivalInc.logger.info("Ghost status change to {} accepted.", (Object)this.getStatus());
    }

    public String getStatus() {
        return status_desc[this.status];
    }

    public boolean isResurrectionReady() {
        return this.resurrection_progress >= ModConfig.GHOST.resurrectionDuration;
    }

    public boolean isResurrectionActive() {
        return this.resurrection_progress > -1;
    }

    public int timeUntilResurrection() {
        return ModConfig.GHOST.resurrectionDuration - this.resurrection_progress;
    }

    public float getResurrectionProgress() {
        return (float)this.resurrection_progress / (float)ModConfig.GHOST.resurrectionDuration;
    }

    public void finishResurrection() {
        this.setValue(0.0f);
        this.setActive(false);
        this.resurrection_progress = -1;
    }

    public void tickResurrection() {
        ++this.resurrection_progress;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = super.serializeNBT();
        tag.func_74757_a("active", this.isActive());
        return tag;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        super.deserializeNBT(nbt);
        this.setActive(nbt.func_74767_n("active"));
    }
}

