/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.ghost.GhostEnergyRecord;
import enginecrafter77.survivalinc.ghost.HelicalParticleSpawner;
import enginecrafter77.survivalinc.ghost.InteractionProcessor;
import enginecrafter77.survivalinc.net.StatSyncMessage;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatProvider;
import enginecrafter77.survivalinc.stats.StatRecord;
import enginecrafter77.survivalinc.stats.StatRegisterEvent;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.effect.EffectApplicator;
import enginecrafter77.survivalinc.stats.effect.EffectFilter;
import enginecrafter77.survivalinc.stats.effect.FunctionalEffectFilter;
import enginecrafter77.survivalinc.stats.effect.SideEffectFilter;
import enginecrafter77.survivalinc.stats.effect.ValueStatEffect;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.FoodStats;
import net.minecraft.util.MovementInput;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GhostProvider
implements StatProvider<GhostEnergyRecord> {
    private static final long serialVersionUID = -2088047893866334112L;
    public static final EffectFilter<GhostEnergyRecord> active = (record, player) -> record.isActive();
    public static final GhostProvider instance = new GhostProvider();
    public static final HelicalParticleSpawner resurrect_particles = new HelicalParticleSpawner(EnumParticleTypes.PORTAL).setHelixCount(8);
    public static final Vec3d rp_box = new Vec3d(0.6, 1.5, 0.6);
    public static final Vec3d rp_offset = new Vec3d(0.0, -0.3, 0.0);
    public final EffectApplicator<GhostEnergyRecord> applicator = new EffectApplicator();
    public final InteractionProcessor interactor;

    public GhostProvider() {
        this.interactor = new InteractionProcessor(PlayerInteractEvent.RightClickBlock.class, (float)ModConfig.GHOST.interactionCost);
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register(GhostProvider.class);
        FunctionalEffectFilter<Object> playerSprinting = FunctionalEffectFilter.byPlayer(Entity::func_70051_ag);
        this.applicator.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, (float)ModConfig.GHOST.passiveNightRegen)).addFilter(GhostProvider::duringNight);
        this.applicator.add(GhostProvider::onGhostUpdate);
        this.applicator.add(GhostProvider::resurrectTick);
        if (ModConfig.GHOST.allowFlying) {
            this.applicator.add(GhostProvider::provideFlying);
        }
        if (ModConfig.GHOST.sprintingEnergyDrain > 0.0) {
            this.applicator.add(new ValueStatEffect(ValueStatEffect.Operation.OFFSET, -((float)ModConfig.GHOST.sprintingEnergyDrain))).addFilter(playerSprinting);
            this.applicator.add(GhostProvider::spawnSprintingParticles).addFilter(SideEffectFilter.CLIENT).addFilter(active).addFilter(playerSprinting);
            this.applicator.add(GhostProvider::synchronizeFood).addFilter(active);
        }
        this.interactor.addBlockClass(BlockDoor.class, 1.0f);
        this.interactor.addBlockClass(BlockFenceGate.class, 0.9f);
        this.interactor.addBlockClass(BlockRedstoneComparator.class, 2.0f);
        this.interactor.addBlockClass(BlockRedstoneRepeater.class, 2.0f);
        this.interactor.addBlockClass(BlockTrapDoor.class, 0.9f);
        this.interactor.setBlockCost(Blocks.field_150430_aB, 0.6f);
        this.interactor.setBlockCost(Blocks.field_150471_bO, 0.5f);
        this.interactor.setBlockCost(Blocks.field_150442_at, 0.75f);
    }

    @Override
    public void update(EntityPlayer target, StatRecord record) {
        GhostEnergyRecord ghost = (GhostEnergyRecord)record;
        if (ghost.shouldReceiveTicks()) {
            this.applicator.apply(ghost, target);
            ghost.checkoutValueChange();
        }
    }

    @Override
    public ResourceLocation getStatID() {
        return new ResourceLocation("survivalinc", "ghostenergy");
    }

    @Override
    public GhostEnergyRecord createNewRecord() {
        return new GhostEnergyRecord();
    }

    @Override
    public Class<GhostEnergyRecord> getRecordClass() {
        return GhostEnergyRecord.class;
    }

    public int energyToFood(GhostEnergyRecord record) {
        return Math.round(4.0f + 16.0f * record.getNormalizedValue());
    }

    @SubscribeEvent
    public static void registerStat(StatRegisterEvent event) {
        event.register(instance);
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (!event.isEndConquered()) {
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            GhostEnergyRecord record = tracker.getRecord(instance);
            record.setActive(true);
            SurvivalInc.proxy.net.sendToAll((IMessage)new StatSyncMessage(player));
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        StatTracker tracker = (StatTracker)event.getEntityPlayer().getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(instance);
        if (record.isActive()) {
            Float cost;
            float energy = record.getValue();
            if (ModConfig.GHOST.enableInteraction && (double)energy >= ModConfig.GHOST.interactionThreshold && (cost = GhostProvider.instance.interactor.apply(event)) != null && energy >= cost.floatValue()) {
                record.addToValue(-cost.floatValue());
                GhostProvider.spawnInteractionParticles(event.getEntityPlayer(), event.getPos(), cost.floatValue());
                return;
            }
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.hasResult()) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerHitEntity(LivingAttackEvent event) {
        StatTracker tracker;
        GhostEnergyRecord record;
        EntityDamageSource attack;
        Entity attacker;
        DamageSource source = event.getSource();
        if (source instanceof EntityDamageSource && (attacker = (attack = (EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer && (record = (tracker = (StatTracker)attacker.getCapability(StatCapability.target, null)).getRecord(instance)).isActive()) {
            Entity victim = event.getEntity();
            Random rng = victim.field_70170_p.field_73012_v;
            for (int pass = 32; pass > 0; --pass) {
                victim.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, victim.field_70165_t + (double)victim.field_70130_N * (rng.nextDouble() - 0.5), victim.field_70163_u + (double)victim.field_70131_O * rng.nextGaussian(), victim.field_70161_v + (double)victim.field_70130_N * (rng.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[0]);
            }
            record.addToValue(-1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Vec3d offset = new Vec3d(3.0, 1.0, 3.0);
        EntityLivingBase target = event.getEntityLiving();
        Vec3d origin = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O / 2.0, 0.0);
        AxisAlignedBB box = new AxisAlignedBB(origin.func_178788_d(offset), origin.func_178787_e(offset));
        List players = target.field_70170_p.func_72872_a(EntityPlayer.class, box);
        for (EntityPlayer player : players) {
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            GhostEnergyRecord record = tracker.getRecord(instance);
            if (!record.isActive() || record.getNormalizedValue() != 1.0f) continue;
            record.tickResurrection();
        }
    }

    @SubscribeEvent
    public static void disableItemPickup(EntityItemPickupEvent event) {
        StatTracker tracker = (StatTracker)event.getEntityPlayer().getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(instance);
        if (record.isActive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void modifyVisibility(PlayerEvent.Visibility event) {
        StatTracker tracker = (StatTracker)event.getEntityPlayer().getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(instance);
        if (record.isActive()) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public static void blockMovementWhileResurrecting(InputUpdateEvent event) {
        StatTracker tracker;
        GhostEnergyRecord record;
        if (ModConfig.GHOST.resurrectionBlocksMovement && (record = (tracker = (StatTracker)event.getEntityPlayer().getCapability(StatCapability.target, null)).getRecord(instance)).isResurrectionActive()) {
            MovementInput input = event.getMovementInput();
            input.field_187255_c = false;
            input.field_187258_f = false;
            input.field_187256_d = false;
            input.field_187257_e = false;
            input.field_192832_b = 0.0f;
            input.field_78902_a = 0.0f;
            input.field_78899_d = false;
            input.field_78901_c = false;
        }
    }

    public static void onGhostUpdate(GhostEnergyRecord record, EntityPlayer player) {
        if (record.hasPendingChange()) {
            boolean isGhost;
            player.field_71075_bZ.field_75102_a = isGhost = record.isActive();
            boolean bl = player.field_71075_bZ.field_75099_e = !isGhost;
            if (player.field_70170_p.field_72995_K && player == Minecraft.func_71410_x().field_71439_g) {
                Minecraft.func_71410_x().field_71474_y.field_74336_f = !isGhost;
            }
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            Collection<StatProvider<?>> providers = tracker.getRegisteredProviders();
            providers.remove(instance);
            for (StatProvider<?> provider : providers) {
                tracker.setSuspended(provider, isGhost);
            }
            record.acceptChange();
        }
    }

    public static void synchronizeFood(GhostEnergyRecord record, EntityPlayer player) {
        FoodStats food = player.func_71024_bL();
        food.func_75114_a(instance.energyToFood(record));
    }

    public static void resurrectTick(GhostEnergyRecord record, EntityPlayer player) {
        if (record.isResurrectionActive()) {
            WorldClient world;
            record.tickResurrection();
            Vec3d origin = player.func_174791_d().func_72441_c(0.0, (double)player.field_70131_O / 2.0, 0.0);
            if (player.field_70170_p.field_72995_K) {
                world = (WorldClient)player.field_70170_p;
                if (record.timeUntilResurrection() == 60) {
                    world.func_184148_a(player, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, SoundEvents.field_187812_eh, SoundCategory.PLAYERS, 0.8f, 1.0f);
                }
                resurrect_particles.spawn(world, origin.func_178787_e(rp_offset), rp_box, Vec3d.field_186680_a, player.field_70173_aa);
            }
            if (record.isResurrectionReady()) {
                record.finishResurrection();
                if (!player.field_70170_p.field_72995_K) {
                    world = (WorldServer)player.field_70170_p;
                    world.func_175739_a(EnumParticleTypes.EXPLOSION_HUGE, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, 10, 0.0, 0.0, 0.0, 0.0, new int[0]);
                    world.func_184148_a(null, origin.field_72450_a, origin.field_72448_b, origin.field_72449_c, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 0.6f, 1.0f);
                }
            }
        }
    }

    public static void spawnSprintingParticles(GhostEnergyRecord record, EntityPlayer player) {
        WorldClient world = (WorldClient)player.field_70170_p;
        world.func_175688_a(EnumParticleTypes.CLOUD, player.field_70142_S, player.field_70137_T + (double)(player.field_70131_O / 2.0f), player.field_70136_U, -player.field_70159_w, 0.1, -player.field_70179_y, new int[0]);
    }

    public static void provideFlying(GhostEnergyRecord record, EntityPlayer player) {
        boolean shouldFly;
        boolean bl = shouldFly = record.isActive() && (double)record.getValue() > ModConfig.GHOST.flyingThreshold;
        if (player.field_71075_bZ.field_75101_c != shouldFly) {
            player.field_71075_bZ.field_75101_c = shouldFly;
        }
        if (player.field_71075_bZ.field_75100_b) {
            record.addToValue(-((float)ModConfig.GHOST.flyingDrain));
            if ((double)record.getValue() < ModConfig.GHOST.flyingThreshold) {
                player.field_71075_bZ.field_75100_b = false;
            }
        }
    }

    public static boolean duringNight(GhostEnergyRecord record, EntityPlayer player) {
        float angle;
        boolean night = player.field_70170_p.field_72995_K ? (angle = player.field_70170_p.func_72826_c(1.0f)) < 0.75f && angle > 0.25f : !player.field_70170_p.func_72935_r();
        return night;
    }

    public static void spawnInteractionParticles(EntityPlayer player, BlockPos position, float cost) {
        if (player.field_70170_p.field_72995_K) {
            AxisAlignedBB box = player.field_70170_p.func_180495_p(position).func_185900_c((IBlockAccess)player.field_70170_p, position).func_186662_g(0.1);
            Vec3d offbound = new Vec3d(box.field_72336_d - box.field_72340_a, box.field_72337_e - box.field_72338_b, box.field_72334_f - box.field_72338_b);
            Vec3d center = new Vec3d((Vec3i)position).func_178787_e(box.func_189972_c());
            Random rng = player.field_70170_p.field_73012_v;
            for (int pass = Math.round(cost * 2.0f); pass > 0; --pass) {
                Vec3d randoff = new Vec3d(rng.nextDouble() - 0.5, rng.nextDouble() - 0.5, rng.nextDouble() - 0.5);
                Vec3d pos = center.func_72441_c(offbound.field_72450_a * randoff.field_72450_a, offbound.field_72448_b * randoff.field_72448_b, offbound.field_72449_c * randoff.field_72449_c);
                player.field_70170_p.func_175688_a(EnumParticleTypes.CLOUD, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, 0.2, 0.0, new int[0]);
            }
        }
    }
}

