/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.Vec3d;

public class HelicalParticleSpawner {
    public static final int subdivisions = 32;
    public final EnumParticleTypes type;
    private int helices;
    private double constantoffset;

    public HelicalParticleSpawner(EnumParticleTypes type) {
        this.type = type;
        this.setHelixCount(4);
    }

    public HelicalParticleSpawner setHelixCount(int helices) {
        this.constantoffset = Math.PI * 2 / (double)helices;
        this.helices = helices;
        return this;
    }

    public int getHelixCount() {
        return this.helices;
    }

    public double getHelixOffset(int helix) {
        return (double)helix * this.constantoffset;
    }

    public void spawn(WorldClient world, Vec3d origin, Vec3d sizes, Vec3d motion, int tick) {
        double height = sizes.field_72448_b * ((double)(1 + tick % 32) / 32.0 - 0.5);
        for (int index = 0; index < this.getHelixCount(); ++index) {
            double argument = (double)tick / (Math.PI * 2) + this.getHelixOffset(index);
            Vec3d position = origin.func_72441_c(sizes.field_72450_a * Math.sin(argument), height, sizes.field_72449_c * Math.cos(argument));
            world.func_175688_a(this.type, position.field_72450_a, position.field_72448_b, position.field_72449_c, motion.field_72450_a, motion.field_72448_b, motion.field_72449_c, new int[0]);
        }
    }
}

