/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import enginecrafter77.survivalinc.config.ModConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class InteractionProcessor
implements Function<PlayerInteractEvent, Float> {
    public final Class<? extends PlayerInteractEvent> eventclass;
    public final Map<Class<? extends Block>, Float> general_cases;
    public final Map<Block, Float> specific_cases = new HashMap<Block, Float>();
    public final float flatrate;

    public InteractionProcessor(Class<? extends PlayerInteractEvent> eventclass, float flatrate) {
        this.general_cases = new HashMap<Class<? extends Block>, Float>();
        this.eventclass = eventclass;
        this.flatrate = flatrate;
    }

    public void setBlockCost(Block block, float multiplier) {
        this.specific_cases.put(block, Float.valueOf(multiplier));
    }

    public void addBlockClass(Class<? extends Block> blockclass, float multiplier) {
        this.general_cases.put(blockclass, Float.valueOf(multiplier));
    }

    public IBlockState getBlock(PlayerInteractEvent event) {
        return event.getWorld().func_180495_p(event.getPos());
    }

    @Override
    public Float apply(PlayerInteractEvent target) {
        Float rate = null;
        if (target.getClass() == this.eventclass) {
            IBlockState blockstate = this.getBlock(target);
            Block block = blockstate.func_177230_c();
            Class<?> blockclass = block.getClass();
            if (this.specific_cases.containsKey(block)) {
                rate = Float.valueOf(this.flatrate * this.specific_cases.get(block).floatValue());
            } else if (this.general_cases.containsKey(blockclass)) {
                rate = Float.valueOf(this.flatrate * this.general_cases.get(blockclass).floatValue());
            } else if (ModConfig.GHOST.interactionSubclassing) {
                for (Map.Entry<Class<? extends Block>, Float> entry : this.general_cases.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(blockclass)) continue;
                    rate = Float.valueOf(this.flatrate * entry.getValue().floatValue());
                    break;
                }
            }
        }
        return rate;
    }
}

