/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.ghost;

import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.ghost.GhostEnergyRecord;
import enginecrafter77.survivalinc.ghost.GhostProvider;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderGhost
extends RenderLivingBase<EntityPlayer> {
    public final ResourceLocation texture;

    public RenderGhost() {
        this((ModelBase)new ModelGhast(), new ResourceLocation("textures/entity/ghast/ghast.png"));
    }

    public RenderGhost(ModelBase model, ResourceLocation texture) {
        super(Minecraft.func_71410_x().func_175598_ae(), model, 0.7f);
        this.texture = texture;
    }

    protected ResourceLocation getEntityTexture(EntityPlayer entity) {
        return this.texture;
    }

    public void doRender(EntityPlayer entity, double x, double y, double z, float entityYaw, float partialTicks) {
        StatTracker tracker = (StatTracker)entity.getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(GhostProvider.instance);
        float opacity = record.getNormalizedValue();
        if (ModConfig.CLIENT.pulsatingGhosts) {
            opacity = (float)((double)opacity * (0.8 + 0.15 * Math.sin((double)((float)entity.field_70173_aa + partialTicks) / (Math.PI * 2))));
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
        if (ModConfig.CLIENT.pulsatingGhosts || opacity < 0.9f) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
            GlStateManager.func_179108_z();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179132_a((boolean)false);
            super.func_76986_a((EntityLivingBase)entity, x, y + 1.0, z, entityYaw, partialTicks);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179133_A();
            GlStateManager.func_179084_k();
        } else {
            super.func_76986_a((EntityLivingBase)entity, x, y + 1.0, z, entityYaw, partialTicks);
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(GhostProvider.instance);
        if (record.isActive()) {
            this.doRender(player, event.getX(), event.getY(), event.getZ(), player.field_70761_aq, event.getPartialRenderTick());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderPlayerHand(RenderHandEvent event) {
        StatTracker tracker = (StatTracker)Minecraft.func_71410_x().field_71439_g.getCapability(StatCapability.target, null);
        GhostEnergyRecord record = tracker.getRecord(GhostProvider.instance);
        if (record.isActive()) {
            event.setCanceled(true);
        }
    }
}

