/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.item;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.impl.HydrationModifier;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCanteen
extends Item {
    public static final int waterBarColor = 2344191;

    public ItemCanteen() {
        this.setRegistryName(new ResourceLocation("survivalinc", "canteen"));
        this.func_77655_b("water_canteen");
        this.func_77637_a(SurvivalInc.mainTab);
        this.func_77625_d(1);
        this.setNoRepair();
    }

    public int getMetadata(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74767_n("refill") ? 1 : 0;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        NBTTagCompound nbt = stack.func_77978_p();
        int stored = nbt.func_74762_e("stored");
        if (nbt.func_74767_n("refill")) {
            stored = ModConfig.HYDRATION.canteenCapacity;
            if (!world.field_72995_K) {
                ((WorldServer)world).func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187549_bG, SoundCategory.PLAYERS, 0.25f, 1.5f);
            }
        } else {
            StatTracker stats = (StatTracker)entity.getCapability(StatCapability.target, null);
            if (stats != null) {
                stats.getRecord(HydrationModifier.instance).addToValue((float)ModConfig.HYDRATION.sipVolume);
                --stored;
            }
        }
        nbt.func_74768_a("stored", stored);
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        NBTTagCompound nbt = item.func_77978_p();
        if (player.func_70093_af()) {
            nbt.func_74757_a("refill", !nbt.func_74767_n("refill"));
            if (world.field_72995_K) {
                ((WorldClient)world).func_184156_a(player.func_180425_c(), SoundEvents.field_187556_aj, SoundCategory.PLAYERS, 0.5f, 1.0f, false);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)item);
        }
        int stored = nbt.func_74762_e("stored");
        boolean result = false;
        if (nbt.func_74767_n("refill")) {
            Vec3d look = player.func_174824_e(1.0f).func_178787_e(player.func_70040_Z().func_72441_c(player.func_70040_Z().field_72450_a < 0.0 ? -0.5 : 0.5, -1.0, player.func_70040_Z().field_72449_c < 0.0 ? -0.5 : 0.5));
            RayTraceResult raytrace = player.field_70170_p.func_72901_a(player.func_174824_e(1.0f), look, true);
            result = raytrace != null && raytrace.field_72313_a == RayTraceResult.Type.BLOCK && world.func_180495_p(raytrace.func_178782_a()).func_185904_a() == Material.field_151586_h && stored < ModConfig.HYDRATION.canteenCapacity;
        } else {
            boolean bl = result = stored > 0;
        }
        if (result) {
            player.func_184598_c(hand);
        }
        return new ActionResult(result ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)item);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("refill", false);
            nbt.func_74768_a("stored", 0);
            stack.func_77982_d(nbt);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        tooltip.add(String.format("Mode: %s", nbt.func_74767_n("refill") ? "REFILL" : "DRAIN"));
        tooltip.add(String.format("Stored: %d/%d mb", nbt.func_74762_e("stored") * 8, ModConfig.HYDRATION.canteenCapacity * 8));
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("refill") ? EnumAction.BOW : EnumAction.DRINK;
    }

    public int func_77626_a(ItemStack stack) {
        int duration = 32;
        if (stack.func_77978_p().func_74767_n("refill")) {
            duration /= 2;
        }
        return duration;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return 1.0 - (double)tag.func_74762_e("stored") / (double)ModConfig.HYDRATION.canteenCapacity;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 2344191;
    }
}

