/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.item;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.net.EntityItemUpdateMessage;
import enginecrafter77.survivalinc.stats.SimpleStatRecord;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatTracker;
import enginecrafter77.survivalinc.stats.impl.WetnessModifier;
import java.util.List;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTowel
extends Item {
    public ItemTowel() {
        this.setRegistryName(new ResourceLocation("survivalinc", "towel"));
        this.func_77637_a(SurvivalInc.mainTab);
        this.func_77655_b("towel");
        this.func_77625_d(1);
    }

    public float getCapacity() {
        return (float)ModConfig.WETNESS.towelCapacity;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        float absorb;
        StatTracker tracker = (StatTracker)entity.getCapability(StatCapability.target, null);
        NBTTagCompound tag = stack.func_77978_p();
        SimpleStatRecord wetness = tracker.getRecord(WetnessModifier.instance);
        float stored = tag.func_74760_g("stored");
        float leave = absorb = (wetness.getValue() + stored) / 2.0f;
        SurvivalInc.logger.debug("TOWEL| W: {}, S: {}, A/L: {}", (Object)wetness, (Object)Float.valueOf(stored), (Object)Float.valueOf(absorb));
        if (absorb > this.getCapacity()) {
            float overflow = absorb - this.getCapacity();
            absorb -= overflow;
            leave += overflow;
            SurvivalInc.logger.debug("TOWEL| \\--> Capacity exceeded");
        }
        SurvivalInc.logger.debug("TOWEL| \\--> A: {}, L: {}", (Object)Float.valueOf(absorb), (Object)Float.valueOf(leave));
        wetness.setValue(leave);
        tag.func_74776_a("stored", absorb);
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!stack.func_77942_o()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74776_a("stored", 0.0f);
            stack.func_77982_d(tag);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            StringBuilder name = new StringBuilder(super.func_77653_i(stack));
            float stored = tag.func_74760_g("stored");
            float quarter = this.getCapacity() / 4.0f;
            name.insert(0, this.getMetadata(stack) == 0 ? "Dry " : "Wet ");
            if (stored < quarter * 3.0f && stored > quarter) {
                name.insert(0, "Mostly ");
            }
            return name.toString();
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        if (stack.func_77942_o()) {
            tooltip.add(String.format("Wetness: %d%%", Math.round(100.0f * (stack.func_77978_p().func_74760_g("stored") / this.getCapacity()))));
        }
    }

    public boolean onEntityItemUpdate(EntityItem entity) {
        BlockPos position;
        World world = entity.field_70170_p;
        ItemStack stack = entity.func_92059_d();
        if (!stack.func_77942_o()) {
            return false;
        }
        NBTTagCompound tag = stack.func_77978_p();
        float stored = tag.func_74760_g("stored");
        if (stored > 0.0f && world.func_180495_p(position = entity.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150470_am) {
            if (world.field_72995_K) {
                WorldClient clientworld = (WorldClient)world;
                if (clientworld.field_73012_v.nextFloat() < 0.2f) {
                    clientworld.func_175688_a(EnumParticleTypes.CLOUD, entity.field_70165_t, entity.field_70163_u + 0.6, entity.field_70161_v, 0.0, (double)0.1f, 0.0, null);
                    clientworld.func_184156_a(entity.func_180425_c(), SoundEvents.field_187659_cY, SoundCategory.NEUTRAL, 0.05f, 1.5f, false);
                }
            } else {
                WorldServer serverworld = (WorldServer)world;
                float post = stored - (float)ModConfig.WETNESS.towelDryRate;
                if (post < 0.0f) {
                    post = 0.0f;
                }
                tag.func_74776_a("stored", post);
                if (this.getMetadata(stored) != this.getMetadata(post) || post == 0.0f) {
                    serverworld.func_73039_n().func_151247_a((Entity)entity, SurvivalInc.proxy.net.getPacketFrom((IMessage)new EntityItemUpdateMessage(entity)));
                }
            }
        }
        return super.onEntityItemUpdate(entity);
    }

    public int getMetadata(float stored) {
        return stored < this.getCapacity() / 2.0f ? 0 : 1;
    }

    public int getMetadata(ItemStack stack) {
        int meta = 0;
        if (stack.func_77942_o()) {
            NBTTagCompound tag = stack.func_77978_p();
            float stored = tag.func_74760_g("stored");
            meta = this.getMetadata(stored);
        }
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o();
    }

    @SideOnly(value=Side.CLIENT)
    public double getDurabilityForDisplay(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return 1.0 - (double)tag.func_74762_e("stored") / (double)this.getCapacity();
    }

    @SideOnly(value=Side.CLIENT)
    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 2344191;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }
}

