/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.net;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.stats.StatCapability;
import enginecrafter77.survivalinc.stats.StatTracker;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatSyncMessage
implements IMessage {
    private final HashMap<UUID, NBTTagCompound> data = new HashMap();

    public StatSyncMessage(World world) {
        for (EntityPlayer player : world.field_73010_i) {
            this.addPlayerTrackerData(player);
        }
    }

    public StatSyncMessage(EntityPlayer player) {
        this.addPlayerTrackerData(player);
    }

    public StatSyncMessage() {
    }

    @SideOnly(value=Side.CLIENT)
    public void loadInto(WorldClient world) {
        Capability.IStorage serializer = StatCapability.target.getStorage();
        for (Map.Entry<UUID, NBTTagCompound> entry : this.data.entrySet()) {
            EntityPlayer player = world.func_152378_a(entry.getKey());
            if (player == null) {
                SurvivalInc.logger.error("Player {} not found on client.", (Object)entry.getKey().toString());
                continue;
            }
            StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
            serializer.readNBT(StatCapability.target, (Object)tracker, null, (NBTBase)entry.getValue());
        }
    }

    public Set<UUID> getPayloadUUIDList() {
        return this.data.keySet();
    }

    public void addPlayerTrackerData(EntityPlayer player) {
        Capability.IStorage serializer = StatCapability.target.getStorage();
        StatTracker tracker = (StatTracker)player.getCapability(StatCapability.target, null);
        NBTTagCompound data = (NBTTagCompound)serializer.writeNBT(StatCapability.target, (Object)tracker, null);
        this.data.put(player.func_110124_au(), data);
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound bundle = ByteBufUtils.readTag((ByteBuf)buf);
        for (String key : bundle.func_150296_c()) {
            NBTTagCompound trackerdata = bundle.func_74775_l(key);
            UUID playeruuid = UUID.fromString(key);
            this.data.put(playeruuid, trackerdata);
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound bundle = new NBTTagCompound();
        for (Map.Entry<UUID, NBTTagCompound> entry : this.data.entrySet()) {
            bundle.func_74782_a(entry.getKey().toString(), (NBTBase)entry.getValue());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)bundle);
    }
}

