/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.season.SeasonData;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class BiomeTempController {
    private static final String[] possiblenames = new String[]{"field_76750_F", "temperature"};
    public final Map<Biome, Float> originals = new HashMap<Biome, Float>();
    public final Set<Class<? extends Biome>> excluded = new HashSet<Class<? extends Biome>>();
    protected final Field target;

    public BiomeTempController() throws NoSuchFieldException {
        Field field = null;
        for (String name : possiblenames) {
            try {
                field = Biome.class.getDeclaredField(name);
                field.setAccessible(true);
            }
            catch (ReflectiveOperationException exc) {
                // empty catch block
            }
        }
        if (field == null) {
            throw new NoSuchFieldException("Temperature field not found in Biome.class");
        }
        this.target = field;
    }

    protected void setTemperature(Biome biome, float temperature) {
        try {
            this.target.setFloat(biome, temperature);
        }
        catch (ReflectiveOperationException exc) {
            exc.printStackTrace();
        }
    }

    protected void resetTemperature(Biome biome) {
        if (this.originals.containsKey(biome)) {
            this.setTemperature(biome, this.originals.get(biome).floatValue());
        }
    }

    public float calculateNewBiomeTemperature(Biome biome, SeasonData data, float offset) {
        return this.originals.get(biome).floatValue() + offset;
    }

    public void applySeason(SeasonData data) {
        long time = System.currentTimeMillis();
        int processed = 0;
        float offset = data.season.getTemperatureOffset(data.day);
        for (Biome biome : ForgeRegistries.BIOMES.getValuesCollection()) {
            if (this.excluded.contains(biome.getClass())) continue;
            if (!this.originals.containsKey(biome)) {
                SurvivalInc.logger.debug("Biome {} has not saved it's original value. Mapping to {}.", (Object)biome.getRegistryName().toString(), (Object)Float.valueOf(biome.func_185353_n()));
                this.originals.put(biome, Float.valueOf(biome.func_185353_n()));
            }
            this.setTemperature(biome, this.calculateNewBiomeTemperature(biome, data, offset));
            ++processed;
        }
        time = System.currentTimeMillis() - time;
        SurvivalInc.logger.info("Processed {} biomes in {} ms", (Object)processed, (Object)time);
    }
}

