/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.season.Season;
import enginecrafter77.survivalinc.season.SeasonData;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LeafColorer
implements IBlockColor {
    public static final LeafColorer instance = new LeafColorer();
    public final Set<BlockPlanks.EnumType> persistentTypes = new HashSet<BlockPlanks.EnumType>();

    public int func_186720_a(IBlockState state, IBlockAccess accessor, BlockPos position, int tint) {
        int rgb;
        BlockPlanks.EnumType treetype = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
        switch (treetype) {
            case SPRUCE: {
                rgb = ColorizerFoliage.func_77466_a();
                break;
            }
            case BIRCH: {
                rgb = ColorizerFoliage.func_77469_b();
                break;
            }
            default: {
                rgb = accessor == null || position == null ? ColorizerFoliage.func_77468_c() : BiomeColorHelper.func_180287_b((IBlockAccess)accessor, (BlockPos)position);
            }
        }
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!this.persistentTypes.contains(treetype) && world != null) {
            Season ssn = SeasonData.load((World)world).season;
            switch (ssn) {
                case WINTER: 
                case AUTUMN: {
                    int component = 0;
                    for (double multiplier : ModConfig.CLIENT.autumnLeafColor) {
                        rgb = LeafColorer.multiplyColor(rgb, component++, (float)multiplier);
                    }
                    break;
                }
            }
        }
        return rgb;
    }

    public static int multiplyColor(int color, int component, float ratio) {
        component = (2 - component) * 8;
        float colorvalue = (float)(color >> component & 0xFF) / 255.0f;
        color &= ~(255 << component);
        return color |= (int)((colorvalue *= ratio) * 255.0f) << component;
    }

    @SubscribeEvent
    public void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a((IBlockColor)this, new Block[]{Blocks.field_150362_t});
        this.persistentTypes.add(BlockPlanks.EnumType.SPRUCE);
    }
}

