/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;

public enum Season {
    WINTER(0.6f, 6008466),
    SPRING(0.7f, 0),
    SUMMER(0.3f, 13296206),
    AUTUMN(0.4f, 13925888);

    public final float rainfallchance;
    public final int grasscolor;

    private Season(float rainfallchance, int grasscolor) {
        this.rainfallchance = rainfallchance;
        this.grasscolor = grasscolor;
    }

    public Season getFollowing(int count) {
        Season[] seasons = Season.values();
        int index = (this.ordinal() + count) % seasons.length;
        if (index < 0) {
            index = seasons.length + index;
        }
        return seasons[index];
    }

    public int getLength() {
        return ModConfig.SEASONS.durations[this.ordinal()];
    }

    public float getPeakTemperatureOffset() {
        return (float)ModConfig.SEASONS.temperatures[this.ordinal()];
    }

    public int getPeakDay() {
        return this.getLength() / 2;
    }

    public static int getYearLength() {
        int counter = 0;
        for (Season current : Season.values()) {
            counter += current.getLength();
        }
        return counter;
    }

    public int getAbsoluteDay(int day) {
        for (int index = 0; index < this.ordinal(); ++index) {
            day += Season.values()[index].getLength();
        }
        return day;
    }

    public float getTemperatureOffset(int days) {
        int way = days > this.getPeakDay() ? 1 : -1;
        Season target = this.getFollowing(way);
        int absolute_day = this.getAbsoluteDay(days);
        int localpeak = this.getAbsoluteDay(this.getPeakDay());
        int targetpeak = target.getAbsoluteDay(target.getPeakDay());
        if (way * target.ordinal() < way * this.ordinal()) {
            targetpeak += way * Season.getYearLength();
        }
        float value = Season.interpolateTemperature(absolute_day, localpeak, targetpeak, this.getPeakTemperatureOffset(), target.getPeakTemperatureOffset());
        SurvivalInc.logger.debug("Season {} day {} transitioning into {} --> {}", (Object)this.toString(), (Object)days, (Object)target.toString(), (Object)Float.valueOf(value));
        return value;
    }

    public String toString() {
        return String.format("%s(%d; %f@%d)", this.name(), this.getLength(), Float.valueOf(this.getPeakTemperatureOffset()), this.getPeakDay());
    }

    private static float interpolateTemperature(float x, float d0, float d1, float a, float b) {
        return (b - a) * ((x - d0) / (d1 - d0)) + a;
    }
}

