/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.season.Season;
import enginecrafter77.survivalinc.season.SeasonChangedEvent;
import enginecrafter77.survivalinc.season.SeasonController;
import enginecrafter77.survivalinc.season.SeasonData;
import enginecrafter77.survivalinc.season.SeasonSyncMessage;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SeasonCommand
extends CommandBase {
    public SeasonCommand() {
        System.out.println("Registering command season");
    }

    public String func_71517_b() {
        return "season";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/season <set|info|advance> [<season> [day]]";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        WorldServer world = server.func_71218_a(DimensionType.OVERWORLD.func_186068_a());
        SeasonData data = SeasonData.load((World)world);
        if (args.length < 1) {
            throw new WrongUsageException("Insufficient arguments\nUsgae: " + this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "set": {
                if (args.length < 3) {
                    throw new WrongUsageException("Insufficient arguments\nUsage: " + this.func_71518_a(sender), new Object[0]);
                }
                data.season = Season.valueOf(args[1]);
                data.day = Integer.parseInt(args[2]);
                sender.func_145747_a((ITextComponent)new TextComponentString("Set calendar time to " + data.toString()));
                data.func_76185_a();
                break;
            }
            case "advance": {
                int days = 1;
                if (args.length >= 2) {
                    days = CommandBase.func_175755_a((String)args[1]);
                }
                data.advance(days);
                sender.func_145747_a((ITextComponent)new TextComponentString("Advancing season by " + days + " days --> " + data.toString()));
                data.func_76185_a();
                break;
            }
            case "info": {
                float currentoffset = data.season.getTemperatureOffset(data.day);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                PrintStream message = new PrintStream(buffer);
                message.format("$aCurrent season:$r %s\n", data.toString());
                message.format("$aSeason Length:$r %d\n", data.season.getLength());
                message.format("$aTemperature Offset on $eDay %d$a:$r %.03f\n", data.day, Float.valueOf(currentoffset));
                message.format("$aPeak Temperature Offset in $e%s$a:$r %f\n", data.season.name(), Float.valueOf(data.season.getPeakTemperatureOffset()));
                message.format("$aCurrent Temperature Inclination:$r %.03f", Float.valueOf(data.season.getTemperatureOffset(data.day + 1) - currentoffset));
                if (sender instanceof Entity) {
                    BlockPos position = new BlockPos(sender.func_174791_d());
                    Biome biome = server.func_71218_a(0).func_180494_b(position);
                    float biometempdiff = biome.func_180626_a(position) - biome.func_185353_n();
                    message.format("\n$aNominal temperature in current biome:$r %.02f ($7%s$r)", SeasonController.instance.biomeTemp.originals.get(biome), SeasonCommand.formatOffset("%.03f", Float.valueOf(currentoffset)));
                    message.format("\n$aTemperature at $eX%d Y%d Z%d$a:$r %.02f ($7%s$r)", position.func_177958_n(), position.func_177956_o(), position.func_177952_p(), Float.valueOf(biome.func_180626_a(position)), SeasonCommand.formatOffset("%.03f", Float.valueOf(biometempdiff)));
                }
                message.close();
                sender.func_145747_a((ITextComponent)new TextComponentString(buffer.toString().replace('$', '\u00a7')));
                break;
            }
        }
        if (data.func_76188_b()) {
            SurvivalInc.proxy.net.sendToDimension((IMessage)new SeasonSyncMessage(data), DimensionType.OVERWORLD.func_186068_a());
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent((World)world, data));
        }
    }

    private static <NUM extends Number> String formatOffset(String formatting, NUM number) {
        StringBuilder builder = new StringBuilder();
        if (number.floatValue() > 0.0f) {
            builder.append('+');
        }
        builder.append(String.format(formatting, number));
        return builder.toString();
    }
}

