/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.season.BiomeTempController;
import enginecrafter77.survivalinc.season.Season;
import enginecrafter77.survivalinc.season.SeasonChangedEvent;
import enginecrafter77.survivalinc.season.SeasonData;
import enginecrafter77.survivalinc.season.SeasonSyncMessage;
import java.util.List;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeEnd;
import net.minecraft.world.biome.BiomeHell;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SeasonController
implements IMessageHandler<SeasonSyncMessage, IMessage> {
    public static final int minecraftDayLength = 24000;
    public static final SeasonController instance = new SeasonController();
    public BiomeTempController biomeTemp;

    private SeasonController() {
        try {
            this.biomeTemp = new BiomeTempController();
            this.biomeTemp.excluded.add(BiomeOcean.class);
            this.biomeTemp.excluded.add(BiomeHell.class);
            this.biomeTemp.excluded.add(BiomeEnd.class);
        }
        catch (NoSuchFieldException exc) {
            RuntimeException nexc = new RuntimeException();
            nexc.initCause(exc);
            throw nexc;
        }
    }

    public void notifyClient(EntityPlayerMP client) {
        SeasonData data = SeasonData.load(client.field_70170_p);
        SurvivalInc.logger.info("Sending season data ({}) to player \"{}\", who just entered overworld", (Object)data.toString(), (Object)client.getDisplayNameString());
        SurvivalInc.proxy.net.sendTo((IMessage)new SeasonSyncMessage(data), client);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(SeasonSyncMessage message, MessageContext ctx) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            SurvivalInc.logger.error("Minecraft remote world tracking instance is null. This is NOT a good thing. Season sync packet dropped...");
        } else {
            if (world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
                throw new RuntimeException("Received a stat update message from outside overworld.");
            }
            SurvivalInc.logger.info("Updateding client's world season data to {}...", (Object)message.data.toString());
            world.func_72823_a("survivalinc_season", (WorldSavedData)message.data);
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent((World)world, message.data));
            SurvivalInc.logger.info("Updated client's world season data to {}", (Object)message.data.toString());
        }
        return null;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70170_p.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            this.notifyClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.toDim == DimensionType.OVERWORLD.func_186068_a()) {
            this.notifyClient((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void loadSeasonData(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent(world));
        }
    }

    @SubscribeEvent
    public void onUpdate(TickEvent.WorldTickEvent event) {
        DimensionType dimension = event.world.field_73011_w.func_186058_p();
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START && dimension == DimensionType.OVERWORLD && event.world.func_72820_D() % 24000L == 1200L) {
            SurvivalInc.logger.info("Season update triggered in {} on {}", (Object)dimension.name(), (Object)event.side.name());
            SeasonData data = SeasonData.load(event.world);
            data.advance(1);
            data.func_76185_a();
            SurvivalInc.proxy.net.sendToDimension((IMessage)new SeasonSyncMessage(data), DimensionType.OVERWORLD.func_186068_a());
            MinecraftForge.EVENT_BUS.post((Event)new SeasonChangedEvent(event.world, data));
        }
    }

    @SubscribeEvent
    public void applySeasonData(SeasonChangedEvent event) {
        WorldInfo info = event.getWorld().func_72912_H();
        this.biomeTemp.applySeason(event.data);
        float randWeather = (float)Math.random();
        if (randWeather < event.getSeason().rainfallchance && info.func_76059_o()) {
            info.func_76084_b(true);
        }
        SurvivalInc.logger.info("Applied biome temperatures for season {}", (Object)event.data.toString());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void biomeGrass(BiomeEvent.GetGrassColor event) {
        float deftemp = event.getBiome().func_185353_n();
        if (deftemp + Season.SUMMER.getPeakTemperatureOffset() < 0.0f) {
            event.setNewColor(Season.WINTER.grasscolor);
        } else if (deftemp + Season.WINTER.getPeakTemperatureOffset() > 1.0f) {
            event.setNewColor(Season.SUMMER.grasscolor);
        } else {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            SeasonData data = SeasonData.load((World)world);
            if (data.season.grasscolor != 0) {
                event.setNewColor(data.season.grasscolor);
            }
        }
    }

    @SubscribeEvent
    public void onCropHarvest(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        IBlockState state = event.getState();
        if (state.func_177230_c() instanceof BlockCrops && !world.field_72995_K) {
            SeasonData data = SeasonData.load(event.getWorld());
            BlockCrops crop = (BlockCrops)state.func_177230_c();
            List drops = event.getDrops();
            if (!crop.func_185525_y(event.getState())) {
                drops.clear();
            } else if (data.season == Season.AUTUMN) {
                for (ItemStack drop : drops) {
                    drop.func_190917_f(drop.func_190916_E());
                }
            }
        }
    }

    @SubscribeEvent
    public void affectGrowth(BlockEvent.CropGrowEvent.Pre event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        SeasonData data = SeasonData.load(world);
        Event.Result result = Event.Result.DEFAULT;
        if (data.season == Season.WINTER) {
            result = Event.Result.DENY;
        }
        event.setResult(result);
    }
}

