/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season;

import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.config.ModConfig;
import enginecrafter77.survivalinc.season.Season;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class SeasonData
extends WorldSavedData {
    public static final String datakey = "survivalinc_season";
    public Season season;
    public int day;

    public SeasonData() {
        this(datakey);
    }

    public SeasonData(String id) {
        super(id);
        this.season = ModConfig.SEASONS.startingSeason;
        this.day = ModConfig.SEASONS.startingDay;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int ordinal = nbt.func_74762_e("season");
        this.season = Season.values()[ordinal];
        this.day = nbt.func_74762_e("day");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("season", this.season.ordinal());
        compound.func_74768_a("day", this.day);
        return compound;
    }

    public String toString() {
        return String.format("%s (Day %d)", this.season.name(), this.day);
    }

    public int advance(int days) {
        int seasons_advanced = 0;
        while (days + this.day >= this.season.getLength()) {
            days -= this.season.getLength() - this.day;
            this.season = this.season.getFollowing(1);
            ++seasons_advanced;
            this.day = 0;
        }
        this.day += days;
        return seasons_advanced;
    }

    public static SeasonData load(World world) {
        MapStorage storage = world.func_175693_T();
        SeasonData data = (SeasonData)storage.func_75742_a(SeasonData.class, datakey);
        if (data == null) {
            SurvivalInc.logger.warn("No season data found in world.");
            data = new SeasonData(datakey);
            storage.func_75745_a(datakey, (WorldSavedData)data);
        }
        return data;
    }
}

