/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season.melting;

import enginecrafter77.survivalinc.season.melting.ChunkFilter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;

public abstract class LayeredChunkFilter
implements ChunkFilter {
    private static final BlockPos chunkBlockRange = new BlockPos(15, 0, 15);
    protected final List<Integer> layers = new ArrayList<Integer>();
    private final int surface_offset;

    public LayeredChunkFilter(int surface_offset) {
        this.surface_offset = surface_offset;
    }

    public LayeredChunkFilter() {
        this(-1024);
    }

    public abstract boolean shouldBlockBeTransformed(Chunk var1, BlockPos var2, IBlockState var3);

    public abstract IBlockState transform(Chunk var1, BlockPos var2, IBlockState var3);

    public LayeredChunkFilter addAbsoluteLayer(int height) throws IndexOutOfBoundsException {
        if (height < 0) {
            throw new IndexOutOfBoundsException("Height cannot be less than 0!");
        }
        return this.addLayer(height);
    }

    public LayeredChunkFilter addSurfaceRelativeLayer(int offset) throws IndexOutOfBoundsException {
        int layer = this.surfaceOffsetToLayer(offset);
        if (layer > 0) {
            throw new IndexOutOfBoundsException("Surface relative offset overflown into positive range!");
        }
        return this.addLayer(layer);
    }

    public LayeredChunkFilter addLayer(int layer) {
        this.layers.add(layer);
        return this;
    }

    public int surfaceOffsetToLayer(int offset) {
        return this.surface_offset + offset;
    }

    protected int layerToSurfaceOffset(int layer) {
        return layer - this.surface_offset;
    }

    @Override
    public void processChunk(Chunk chunk) {
        for (int layer : this.layers) {
            this.processChunkLayer(chunk, layer);
        }
    }

    protected BlockPos moveToLayer(Chunk chunk, BlockPos position, int layer) {
        if (layer < 0) {
            layer = chunk.func_177440_h(position).func_177956_o() - 1 + this.layerToSurfaceOffset(layer);
        }
        return new BlockPos(position.func_177958_n(), layer, position.func_177952_p());
    }

    protected void processChunkLayer(Chunk chunk, int layer) {
        for (BlockPos position : BlockPos.func_177980_a((BlockPos)BlockPos.field_177992_a, (BlockPos)chunkBlockRange)) {
            IBlockState state;
            if (!this.shouldBlockBeTransformed(chunk, position = this.moveToLayer(chunk, position, layer), state = chunk.func_177435_g(position)) || (state = this.transform(chunk, position, state)) == null) continue;
            chunk.func_177436_a(position, state);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        for (Integer layer : this.layers) {
            if (layer < 0) {
                layer = this.layerToSurfaceOffset(layer);
                builder.append('S');
                if (layer >= 0) {
                    builder.append('+');
                }
            }
            builder.append(layer);
            builder.append(", ");
        }
        builder.setLength(builder.length() - 2);
        builder.append(']');
        return builder.toString();
    }
}

