/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.season.melting;

import com.google.common.collect.ImmutableSet;
import enginecrafter77.survivalinc.SurvivalInc;
import enginecrafter77.survivalinc.block.BlockMelting;
import enginecrafter77.survivalinc.season.SeasonChangedEvent;
import enginecrafter77.survivalinc.season.melting.ChunkFilter;
import enginecrafter77.survivalinc.season.melting.LazyMeltingTransformer;
import enginecrafter77.survivalinc.season.melting.MeltingTransformer;
import enginecrafter77.survivalinc.season.melting.MinimalMeltingTransformer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public enum MeltingController {
    FANCY(MeltingTransformer::new),
    LAZY(LazyMeltingTransformer::new),
    SIMPLE(MinimalMeltingTransformer::new),
    NONE(null);

    public static final Set<MelterEntry> meltmap;
    private static List<ChunkFilter> transformers;
    private final Function<BlockMelting, MeltingTransformer> factory;

    private MeltingController(Function<BlockMelting, MeltingTransformer> factory) {
        this.factory = factory;
    }

    public boolean isValid() {
        return this.factory != null;
    }

    public boolean requiresRandomTicks() {
        return this == FANCY;
    }

    public static void compile(MeltingController controller) {
        if (!controller.isValid()) {
            throw new UnsupportedOperationException("Controller " + controller.name() + " is not capable of compilation!");
        }
        for (MelterEntry entry : meltmap) {
            MeltingTransformer transformer = controller.factory.apply(entry.block);
            for (Map.Entry<Integer, Boolean> levelentry : entry.levelmap.entrySet()) {
                int level = levelentry.getKey();
                if (levelentry.getValue().booleanValue()) {
                    level = transformer.surfaceOffsetToLayer(level);
                }
                transformer.addLayer(level);
            }
            transformers.add(transformer);
        }
    }

    public static void registerCustomTransformer(ChunkFilter filter) {
        transformers.add(filter);
    }

    public static void processChunks(Collection<Chunk> chunks) {
        for (ChunkFilter transformer : transformers) {
            for (Chunk chunk : chunks) {
                transformer.processChunk(chunk);
            }
        }
    }

    @SubscribeEvent
    public static void onSeasonUpdate(SeasonChangedEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        WorldServer serverworld = (WorldServer)world;
        ChunkProviderServer provider = serverworld.func_72863_F();
        Collection chunks = provider.func_189548_a();
        SurvivalInc.logger.info("Preparing to process {} chunks...", (Object)chunks.size());
        long overall_time = System.currentTimeMillis();
        serverworld.field_72984_F.func_76320_a("chunktransformer");
        MeltingController.processChunks(chunks);
        serverworld.field_72984_F.func_76319_b();
        overall_time = System.currentTimeMillis() - overall_time;
        SurvivalInc.logger.info("Chunk processing done using all transformers in {} ms", (Object)overall_time);
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K || world.field_73011_w.func_186058_p() != DimensionType.OVERWORLD) {
            return;
        }
        MeltingController.processChunks((Collection<Chunk>)ImmutableSet.of((Object)event.getChunk()));
    }

    static {
        meltmap = new HashSet<MelterEntry>();
        transformers = new LinkedList<ChunkFilter>();
    }

    public static class MelterEntry {
        public final Map<Integer, Boolean> levelmap = new HashMap<Integer, Boolean>();
        public final BlockMelting block;

        public MelterEntry(BlockMelting block) {
            this.block = block;
        }

        public MelterEntry level(int level, boolean surface) {
            this.levelmap.put(level, surface);
            return this;
        }
    }
}

