/*
 * Decompiled with CFR 0.152.
 */
package enginecrafter77.survivalinc.stats;

import com.google.common.collect.Range;
import enginecrafter77.survivalinc.stats.StatRecord;
import net.minecraft.nbt.NBTTagCompound;

public class SimpleStatRecord
implements StatRecord {
    private Range<Float> valuerange = Range.all();
    protected float value = 0.0f;
    private float lastvalue = 0.0f;
    private float change = 0.0f;

    protected void checkValue() {
        Range<Float> range = this.getValueRange();
        if (!range.contains((Comparable)Float.valueOf(this.value))) {
            Float midpoint = Float.valueOf(((Float)range.lowerEndpoint()).floatValue() + (((Float)range.upperEndpoint()).floatValue() - ((Float)range.lowerEndpoint()).floatValue()) / 2.0f);
            switch (midpoint.compareTo(Float.valueOf(this.value))) {
                case -1: {
                    this.value = ((Float)range.upperEndpoint()).floatValue();
                    break;
                }
                case 1: {
                    this.value = ((Float)range.lowerEndpoint()).floatValue();
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public Range<Float> getValueRange() {
        return this.valuerange;
    }

    public void setValueRange(Range<Float> range) {
        this.valuerange = range;
    }

    public void setValue(float value) {
        this.value = value;
        this.checkValue();
    }

    public float getValue() {
        return this.value;
    }

    public float getNormalizedValue() throws IllegalStateException {
        Range<Float> range = this.getValueRange();
        return (this.value - ((Float)range.lowerEndpoint()).floatValue()) / (((Float)range.upperEndpoint()).floatValue() - ((Float)range.lowerEndpoint()).floatValue());
    }

    public void addToValue(float value) {
        this.value += value;
        this.checkValue();
    }

    public float getLastChange() {
        return this.change;
    }

    public void checkoutValueChange() {
        this.change = this.value - this.lastvalue;
        this.lastvalue = this.value;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("value", this.value);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.value = nbt.func_74760_g("value");
    }

    public String toString() {
        return String.format("%f (/\\: %f)", Float.valueOf(this.getValue()), Float.valueOf(this.getLastChange()));
    }
}

